/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.providers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import openmods.reflection.TypeUtils;
import openmods.serializable.IGenericSerializerProvider;
import openmods.serializable.SerializerRegistry;
import openmods.utils.ByteUtils;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.InputBitStream;
import openmods.utils.io.OutputBitStream;
import openmods.utils.io.StreamUtils;

public class MapSerializerProvider
implements IGenericSerializerProvider {
    @Override
    public IStreamSerializer<?> getSerializer(Type type) {
        TypeToken typeToken = TypeToken.of((Type)type);
        if (TypeUtils.MAP_TOKEN.isAssignableFrom(typeToken)) {
            TypeToken keyType = typeToken.resolveType(TypeUtils.MAP_KEY_PARAM);
            TypeToken valueType = typeToken.resolveType(TypeUtils.MAP_VALUE_PARAM);
            final IStreamSerializer<Object> keySerializer = MapSerializerProvider.getSerializer(keyType);
            final IStreamSerializer<Object> valueSerializer = MapSerializerProvider.getSerializer(valueType);
            return new IStreamSerializer<Map<Object, Object>>(){

                @Override
                public Map<Object, Object> readFromStream(DataInput input) throws IOException {
                    int length = ByteUtils.readVLI(input);
                    HashMap result = Maps.newHashMap();
                    if (length > 0) {
                        int nullBitsSize = StreamUtils.bitsToBytes(length * 2);
                        byte[] nullBits = StreamUtils.readBytes(input, nullBitsSize);
                        InputBitStream nullBitStream = InputBitStream.create(nullBits);
                        for (int i = 0; i < length; ++i) {
                            Object key = null;
                            if (nullBitStream.readBit()) {
                                key = keySerializer.readFromStream(input);
                            }
                            Object value = null;
                            if (nullBitStream.readBit()) {
                                value = valueSerializer.readFromStream(input);
                            }
                            result.put(key, value);
                        }
                    }
                    return result;
                }

                @Override
                public void writeToStream(Map<Object, Object> o, DataOutput output) throws IOException {
                    int length = o.size();
                    ByteUtils.writeVLI(output, length);
                    if (length > 0) {
                        ByteArrayDataOutput nullBits = ByteStreams.newDataOutput();
                        OutputBitStream nullBitsStream = OutputBitStream.create((DataOutput)nullBits);
                        ImmutableList entries = ImmutableList.copyOf(o.entrySet());
                        for (Map.Entry e : entries) {
                            nullBitsStream.writeBit(e.getKey() != null);
                            nullBitsStream.writeBit(e.getValue() != null);
                        }
                        nullBitsStream.flush();
                        output.write(nullBits.toByteArray());
                        for (Map.Entry e : entries) {
                            this.writeValue(e.getKey(), keySerializer, output);
                            this.writeValue(e.getValue(), valueSerializer, output);
                        }
                    }
                }

                private void writeValue(Object value, IStreamSerializer<Object> serializer, DataOutput output) throws IOException {
                    if (value != null) {
                        serializer.writeToStream(value, output);
                    }
                }
            };
        }
        return null;
    }

    private static IStreamSerializer<Object> getSerializer(TypeToken<?> type) {
        IStreamSerializer<Object> keySerializer = SerializerRegistry.instance.findSerializer(type.getType());
        Preconditions.checkNotNull(keySerializer, (String)"Can't find serializer for %s", (Object[])new Object[]{type});
        return keySerializer;
    }
}

