/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import java.util.Map;
import openmods.datastore.DataStoreBuilder;
import openmods.network.IdSyncManager;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventDispatcher;
import openmods.network.event.NetworkEventRegistry;
import openmods.utils.io.TypeRW;

public class NetworkEventManager {
    public static final NetworkEventManager INSTANCE = new NetworkEventManager();
    private final NetworkEventRegistry registry = new NetworkEventRegistry();
    private final NetworkEventDispatcher dispatcher = new NetworkEventDispatcher(this.registry);
    private RegistrationContext registrationContext = new RegistrationContext();

    private NetworkEventManager() {
    }

    public RegistrationContext startRegistration() {
        Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.PREINITIALIZATION), (Object)"This method can only be called in pre-initialization state");
        return this.registrationContext;
    }

    public void finalizeRegistration() {
        this.registrationContext.register(this.registry);
        this.registrationContext = null;
    }

    public NetworkEventDispatcher dispatcher() {
        return this.dispatcher;
    }

    public static class RegistrationContext {
        private int currentId = 0;
        private final DataStoreBuilder<String, Integer> builder;
        private final Map<String, Class<? extends NetworkEvent>> events = Maps.newHashMap();

        private RegistrationContext() {
            this.builder = IdSyncManager.INSTANCE.createDataStore("events", String.class, Integer.class);
            this.builder.setDefaultKeyReaderWriter();
            this.builder.setValueReaderWriter(TypeRW.VLI_SERIALIZABLE);
        }

        public RegistrationContext register(Class<? extends NetworkEvent> cls) {
            Preconditions.checkState((boolean)Loader.instance().isInState(LoaderState.PREINITIALIZATION), (Object)"This method can only be called in pre-initialization state");
            String id = cls.getName();
            this.builder.addEntry(id, this.currentId++);
            this.events.put(id, cls);
            return this;
        }

        void register(NetworkEventRegistry eventIdVisitor) {
            eventIdVisitor.registerClasses(this.events);
            this.builder.addVisitor(eventIdVisitor);
            this.builder.register();
        }
    }
}

