/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.minefactoryreloaded;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityComposter;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerComposter
extends RecipeHandlerBase {
    private static Item fertilizer;
    private static int sewagePerOperation;
    private static int energyPerOperation;

    @Override
    public void prepare() {
        fertilizer = GameRegistry.findItem((String)"MineFactoryReloaded", (String)"fertilizer");
        if (fertilizer == null) {
            fertilizer = GameRegistry.findItem((String)"MineFactoryReloaded", (String)"item.mfr.fertilizer");
        }
        TileEntityComposter dummy = new TileEntityComposter();
        sewagePerOperation = dummy.getWorkMax() * 20;
        energyPerOperation = dummy.getActivationEnergy() * dummy.getWorkMax();
        dummy = null;
    }

    public String getRecipeName() {
        return Utils.translate("tile.mfr.machine.composter.name", false);
    }

    @Override
    public String getRecipeID() {
        return "minefactoryreloaded.composter";
    }

    public String getGuiTexture() {
        return "minefactoryreloaded:textures/gui/composter.png";
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)11, (int)13, (int)160, (int)65);
        this.changeToOverlayTexture();
        GuiDraw.drawTexturedModalRect((int)76, (int)25, (int)0, (int)15, (int)22, (int)15);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(129, 0, 176, 58, 8, 62, 1.0f, 3);
        this.drawProgressBar(139, 0, 185, 58, 8, 62, 40, 3);
    }

    @Override
    public List<String> provideTooltip(GuiRecipe<?> guiRecipe, List<String> currenttip, RecipeHandlerBase.CachedBaseRecipe crecipe, Point relMouse) {
        super.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        if (new Rectangle(129, 2, 8, 60).contains(relMouse)) {
            currenttip.add(energyPerOperation + " RF");
        }
        return currenttip;
    }

    @Override
    public void loadAllRecipes() {
        this.arecipes.add(new CachedComposterRecipe());
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() == fertilizer) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (ingredient.getFluid().getName().equals("sewage")) {
            this.loadAllRecipes();
        }
    }

    public class CachedComposterRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank sewageInput;
        public PositionedStack output;

        public CachedComposterRecipe() {
            this.sewageInput = new PositionedFluidTank(FluidRegistry.getFluidStack((String)"sewage", (int)sewagePerOperation), 4000, new Rectangle(111, 2, 16, 60), RecipeHandlerComposter.this.getGuiTexture(), new Point(176, 0));
            this.output = new PositionedStack((Object)new ItemStack(fertilizer), 48, 24);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.sewageInput;
        }
    }
}

