/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util.gregtech5;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public final class GregTechOreDictUtil {
    private GregTechOreDictUtil() {
    }

    public static ItemComponent getComponent(ItemList item) {
        return ItemComponent.create(item.get(1L, new Object[0]));
    }

    public static Optional<ItemComponent> getComponent(OrePrefixes prefix, Materials material) {
        Optional<ItemStack> itemStackOptional = Optional.ofNullable(GT_OreDictUnificator.get((OrePrefixes)prefix, (Object)material, (long)1L));
        return itemStackOptional.map(ItemComponent::create);
    }

    public static List<ItemComponent> getAllComponents(OrePrefixes prefix, Materials material) {
        ArrayList itemStacks = GT_OreDictUnificator.getOres((OrePrefixes)prefix, (Object)material);
        return itemStacks.stream().map(ItemComponent::create).collect(Collectors.toList());
    }

    public static Component unify(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return component;
        }
        return ItemComponent.create(GT_OreDictUnificator.get_nocopy((ItemStack)((ItemStack)component.stack())));
    }

    public static List<Component> reverseUnify(Component component) {
        Component unified = GregTechOreDictUtil.unify(component);
        ArrayList<Component> results = new ArrayList<Component>();
        if (unified.type() == Component.ComponentType.ITEM) {
            GT_OreDictUnificator.getNonUnifiedStacks((Object)unified.stack()).forEach(itemStack -> results.add(ItemComponent.create(itemStack)));
        } else {
            results.add(unified);
        }
        return results;
    }

    public static Optional<ItemData> getItemData(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return Optional.empty();
        }
        return Optional.ofNullable(GT_OreDictUnificator.getAssociation((ItemStack)((ItemStack)component.stack())));
    }

    public static List<Component> getAssociatedComponents(Component component) {
        ArrayList<Component> results = new ArrayList<Component>(GregTechOreDictUtil.reverseUnify(component));
        Optional<ItemData> itemDataOptional = GregTechOreDictUtil.getItemData(component);
        if (itemDataOptional.isPresent()) {
            ItemData itemData = itemDataOptional.get();
            itemData.mPrefix.mFamiliarPrefixes.forEach(prefix -> GregTechOreDictUtil.getComponent(prefix, itemData.mMaterial.mMaterial).ifPresent(c -> results.addAll(GregTechOreDictUtil.reverseUnify(c))));
        }
        return results;
    }
}

