/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.util;

import codechicken.nei.ItemList;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictUtil {
    private OreDictUtil() {
    }

    public static List<String> getOreNames(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return Lists.newArrayList();
        }
        return Arrays.stream(OreDictionary.getOreIDs((ItemStack)((ItemStack)component.stack()))).mapToObj(OreDictionary::getOreName).collect(Collectors.toList());
    }

    public static List<ItemComponent> getComponents(String oreName) {
        ArrayList<ItemComponent> components = new ArrayList<ItemComponent>();
        for (ItemStack itemStack : OreDictionary.getOres((String)oreName, (boolean)false)) {
            components.add(ItemComponent.create(itemStack));
        }
        return components;
    }

    public static List<Component> getPermutations(Component component) {
        if (component.type() != Component.ComponentType.ITEM) {
            return Lists.newArrayList((Object[])new Component[]{component});
        }
        ItemComponent itemComponent = (ItemComponent)component;
        if (itemComponent.hasWildcardDamage()) {
            List permutations = ItemList.itemMap.get((Object)itemComponent.item());
            if (!permutations.isEmpty()) {
                return permutations.stream().map(ItemComponent::create).collect(Collectors.toList());
            }
            return Lists.newArrayList((Object[])new Component[]{ItemComponent.create(itemComponent.item(), 0, itemComponent.nbt())});
        }
        return Lists.newArrayList((Object[])new Component[]{component});
    }
}

