/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.ComponentLabel;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.GregTechRecipeDebugger;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.LayoutFactory;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.recipedebugger.RecipePartitioner;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.ComponentTransformer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

class DiagramHandler {
    private final DiagramGroupInfo info;
    private final LayoutFactory layoutFactory;
    private final RecipeHandler recipeHandler;
    private final ListMultimap<GregTechRecipeDebugger.View, Diagram> diagramListMultimap;
    private Diagram menuDiagram;

    DiagramHandler(DiagramGroupInfo info, LayoutFactory layoutFactory, RecipeHandler recipeHandler) {
        this.info = info;
        this.layoutFactory = layoutFactory;
        this.recipeHandler = recipeHandler;
        this.diagramListMultimap = MultimapBuilder.enumKeys(GregTechRecipeDebugger.View.class).arrayListValues().build();
    }

    void initialize() {
        this.diagramListMultimap.put((Object)GregTechRecipeDebugger.View.PROGRAMMED_CIRCUITS, (Object)this.buildProgrammedCircuitsDiagram());
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.CONSUME_CIRCUIT_RECIPES, this.buildRecipeDiagrams(this.recipeHandler.consumeCircuitRecipes));
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.UNNECESSARY_CIRCUIT_RECIPES, this.buildRecipeDiagrams(this.recipeHandler.unnecessaryCircuitRecipes));
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.COLLIDING_RECIPES, this.buildRecipeDiagrams((List<RecipeHandler.Recipe>)ImmutableList.copyOf(this.recipeHandler.collidingRecipes)));
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.VOIDING_RECIPES, this.buildRecipeDiagrams(this.recipeHandler.voidingRecipes));
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.UNEQUAL_CELL_RECIPES, this.buildRecipeDiagrams(this.recipeHandler.unequalCellRecipes));
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.SMALL_VARIANT_RECIPES, this.buildRecipeDiagrams(this.recipeHandler.smallVariantRecipes));
        this.diagramListMultimap.putAll((Object)GregTechRecipeDebugger.View.BAD_CRAFTING_TABLE_RECIPES, this.buildRecipeDiagrams(this.recipeHandler.badCraftingTableRecipes));
        this.menuDiagram = this.buildMenuDiagram();
    }

    List<Diagram> getMenuDiagram() {
        return Lists.newArrayList((Object[])new Diagram[]{this.menuDiagram});
    }

    List<Diagram> getDiagrams(GregTechRecipeDebugger.View view) {
        return this.diagramListMultimap.get((Object)view);
    }

    private CustomInteractable buildViewButton(GregTechRecipeDebugger.View view) {
        return CustomInteractable.builder(ComponentLabel.create(view.icon, (Point)LayoutFactory.VIEW_BUTTON_POSITIONS.get((Object)view))).setTooltip(Tooltip.builder().setFormatting(Tooltip.SPECIAL_FORMATTING).addTextLine(Lang.GREGTECH_5_RECIPE_DEBUGGER.trans(view.tooltipKey)).addSpacing().setFormatting(Tooltip.INFO_FORMATTING).addTextLine(Lang.GREGTECH_5_RECIPE_DEBUGGER.transf("diagramcount", this.diagramListMultimap.get((Object)view).size())).build()).setInteract(view.behaviorId(this.info)).setDrawBackground(Draw::drawRaisedSlot).setDrawOverlay(pos -> Draw.drawOverlay(pos, -2147483393)).build();
    }

    private Diagram buildMenuDiagram() {
        int recipeCount = this.recipeHandler.allRecipes.values().stream().mapToInt(RecipePartitioner::size).sum();
        Diagram.Builder builder = Diagram.builder().addLayout(this.layoutFactory.buildMenuLayout(recipeCount));
        Arrays.stream(GregTechRecipeDebugger.View.values()).forEach(view -> builder.addInteractable(this.buildViewButton((GregTechRecipeDebugger.View)((Object)view))));
        return builder.build();
    }

    private Diagram buildProgrammedCircuitsDiagram() {
        Diagram.Builder builder = Diagram.builder().addLayout(this.layoutFactory.buildProgrammedCircuitsLayout());
        List<DisplayComponent> programmedCircuits = RecipeHandler.PROGRAMMED_CIRCUITS.stream().map(ComponentTransformer::transformToDisplay).collect(Collectors.toList());
        builder.autoInsertIntoSlotGroup(LayoutFactory.SlotGroupKeys.PROGRAMMED_CIRCUITS).insertEachSafe(programmedCircuits);
        return builder.build();
    }

    private List<Diagram> buildRecipeDiagrams(List<RecipeHandler.Recipe> recipes) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        List partitionedRecipes = Lists.partition(recipes, (int)3);
        for (List partition : partitionedRecipes) {
            Diagram.Builder builder = Diagram.builder().addInteractable(this.layoutFactory.menuButton());
            for (int i = 0; i < partition.size(); ++i) {
                RecipeHandler.Recipe recipe = (RecipeHandler.Recipe)partition.get(i);
                builder.addLayout(this.layoutFactory.buildRecipeLayout(i, recipe.recipeMap()));
                builder.autoInsertIntoSlotGroup((Layout.SlotGroupKey)LayoutFactory.SlotGroupKeys.RECIPE_INPUTS.get(i)).insertEachSafe((Iterable<DisplayComponent>)recipe.displayInputs());
                builder.autoInsertIntoSlotGroup((Layout.SlotGroupKey)LayoutFactory.SlotGroupKeys.RECIPE_OUTPUTS.get(i)).insertEachSafe((Iterable<DisplayComponent>)recipe.displayOutputs());
            }
            diagrams.add(builder.build());
        }
        return diagrams;
    }
}

