/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import gregtech.api.enums.ItemList;
import gregtech.common.blocks.GT_Block_Casings5;
import net.minecraft.item.ItemStack;

class HeatingCoilHandler {
    private static final ImmutableList<ItemList> HEATING_COILS = ImmutableList.of((Object)ItemList.Casing_Coil_Cupronickel, (Object)ItemList.Casing_Coil_Kanthal, (Object)ItemList.Casing_Coil_Nichrome, (Object)ItemList.Casing_Coil_TungstenSteel, (Object)ItemList.Casing_Coil_HSSG, (Object)ItemList.Casing_Coil_Naquadah, (Object)ItemList.Casing_Coil_NaquadahAlloy, (Object)ItemList.Casing_Coil_ElectrumFlux, (Object)ItemList.Casing_Coil_AwakenedDraconium, (Object)ItemList.Casing_Coil_HSSS, (Object)ItemList.Casing_Coil_Trinium, (Object)ItemList.Casing_Coil_Infinity, (Object[])new ItemList[]{ItemList.Casing_Coil_Hypogen, ItemList.Casing_Coil_Eternal});
    private ImmutableSortedMap<Long, Component> heatingCoilMap;

    HeatingCoilHandler() {
    }

    void initialize() {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (ItemList item : HEATING_COILS) {
            ItemStack itemStack = item.get(1L, new Object[0]);
            long heat = GT_Block_Casings5.getCoilHeatFromDamage((int)ItemComponent.getItemDamage(itemStack)).getHeat();
            builder.put((Object)heat, (Object)ItemComponent.create(itemStack));
        }
        this.heatingCoilMap = builder.build();
    }

    ImmutableSortedMap<Long, Component> getHeatingCoils(long heat) {
        return this.heatingCoilMap.tailMap((Object)heat, true);
    }
}

