/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.ComponentDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.DiagramFactory;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;

public final class GregTechLenses
implements DiagramGenerator {
    public static final ItemComponent ICON = GregTechOreDictUtil.getComponent(OrePrefixes.lens, Materials.Emerald).get();
    private final DiagramGroupInfo info;
    private final LayoutHandler layoutHandler;
    private final RecipeHandler recipeHandler;
    private final DiagramFactory diagramFactory;

    public GregTechLenses(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.GREGTECH_5_LENSES.trans("groupname"), groupId, ICON, 1).setDescription("This diagram displays GregTech lens colours and recipes.").build();
        this.layoutHandler = new LayoutHandler(this.info);
        this.recipeHandler = new RecipeHandler();
        this.diagramFactory = new DiagramFactory(this.layoutHandler, this.recipeHandler);
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public DiagramGroup generate() {
        this.layoutHandler.initialize();
        this.recipeHandler.initialize();
        ComponentDiagramMatcher.Builder matcherBuilder = ComponentDiagramMatcher.builder();
        this.recipeHandler.allLenses().forEach(lens -> this.diagramFactory.buildDiagrams((RecipeHandler.Lens)lens, matcherBuilder));
        return new DiagramGroup(this.info, matcherBuilder.build());
    }
}

