/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.debug.ruler;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Grid;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.CustomDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.config.DiagramGroupVisibility;
import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.init.Items;

public final class DebugRuler
implements DiagramGenerator {
    public static final ItemComponent ICON = ItemComponent.create(Items.field_151111_aL, 0);
    private static final int RULER_WIDTH_PIXELS = 332;
    private static final int RULER_HEIGHT_PIXELS = 664;
    private static final int RULER_WIDTH_SLOTS = 14;
    private static final int RULER_HEIGHT_SLOTS = 28;
    private static final int RULER_SEGMENT_PIXELS = 10;
    private static final int RULER_COLOUR_1 = -65536;
    private static final int RULER_COLOUR_2 = -16776961;
    private static final String SLOT_KEY_FORMAT_STRING = "slot(%d,%d)";
    private final DiagramGroupInfo info;
    private Layout layout;

    public DebugRuler(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.DEBUG_RULER.trans("groupname"), groupId, ICON, 1).setIgnoreNbt(false).setDefaultVisibility(DiagramGroupVisibility.DISABLED).setDescription("This diagram has markings to measure the GUI height in pixels.\nYou can also use it to view NBT data for any item.\nThe tab icon also works as a compass!").build();
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public DiagramGroup generate() {
        this.layout = DebugRuler.buildLayout();
        return new DiagramGroup(this.info, new CustomDiagramMatcher(this::generateDiagrams));
    }

    private Collection<Diagram> generateDiagrams(Interactable.RecipeType recipeType, Component component) {
        return Lists.newArrayList((Object[])new Diagram[]{Diagram.builder().addLayout(this.layout).insertIntoSlot(Layout.SlotKey.create(String.format(SLOT_KEY_FORMAT_STRING, 0, 0)), DisplayComponent.builder(component).build()).build()});
    }

    private static Layout buildLayout() {
        Lines.Builder linesBuilder;
        int i;
        Layout.Builder layoutBuilder = Layout.builder();
        Lines.Builder rulerColour1 = Lines.builder(Point.create(0, 0)).setColour(-65536);
        Lines.Builder rulerColour2 = Lines.builder(Point.create(0, 0)).setColour(-16776961);
        for (i = 10; i <= 332; i += 10) {
            linesBuilder = i % 20 > 0 ? rulerColour1 : rulerColour2;
            linesBuilder.move(Point.create(i + 1 - 10, 0));
            linesBuilder.addSegment(Point.create(i - 1, 0));
        }
        for (i = 10; i <= 664; i += 10) {
            linesBuilder = i % 20 > 0 ? rulerColour1 : rulerColour2;
            linesBuilder.move(Point.create(0, i + 1 - 10));
            linesBuilder.addSegment(Point.create(0, i - 1));
        }
        for (i = 0; i < 14; ++i) {
            for (int j = 0; j < 28; ++j) {
                layoutBuilder.putSlot(Layout.SlotKey.create(String.format(SLOT_KEY_FORMAT_STRING, i, j)), Slot.builder(Grid.GRID.grid(2 * i, 2 * j)).setTooltip(Tooltip.create(Lang.DEBUG_RULER.transf("slotlabel", i + 1, j + 1), Tooltip.INFO_FORMATTING)).build());
            }
        }
        return layoutBuilder.addLines(rulerColour1.build()).addLines(rulerColour2.build()).build();
    }
}

