/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.InteractiveComponentGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Drawable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class Diagram {
    protected final Layout layout;
    protected final ImmutableMultiset<Layout.Key> slotInsertions;
    protected final ImmutableList<? extends Interactable> interactables;

    public Diagram(Layout layout, Multiset<Layout.Key> slotInsertions, ImmutableList<? extends Interactable> interactables) {
        this.layout = layout;
        this.slotInsertions = ImmutableMultiset.copyOf(slotInsertions);
        this.interactables = interactables;
    }

    public Diagram(Layout layout, ImmutableList<? extends Interactable> interactables) {
        this(layout, (Multiset<Layout.Key>)ImmutableMultiset.of(), interactables);
    }

    public ImmutableMultiset<Layout.Key> slotInsertions() {
        return this.slotInsertions;
    }

    public Iterable<Interactable> interactables(DiagramState diagramState) {
        return Iterables.concat(this.interactables, this.layout.allSlots());
    }

    public Dimension dimension(DiagramState diagramState) {
        return Dimension.max(this.layout.maxDimension(), Drawable.computeMaxDimension(this.interactables));
    }

    public void drawBackground(DiagramState diagramState) {
        this.layout.draw(diagramState);
    }

    public void drawForeground(DiagramState diagramState) {
        this.interactables.forEach(interactable -> interactable.draw(diagramState));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Layout, Boolean> layouts = new HashMap<Layout, Boolean>();
        private final Multiset<Layout.Key> slotInsertions = HashMultiset.create();
        private final Map<Layout.SlotGroupKey, SlotGroupAutoSubBuilder> slotGroupAutoSubBuilders = new HashMap<Layout.SlotGroupKey, SlotGroupAutoSubBuilder>();
        private final ImmutableList.Builder<Interactable> interactablesBuilder = ImmutableList.builder();

        private Builder() {
        }

        private Layout findLayoutContainingSlot(Layout.SlotKey key) {
            for (Layout layout : this.layouts.keySet()) {
                Optional<Slot> slot = layout.slot(key);
                if (!slot.isPresent()) continue;
                return layout;
            }
            throw new IllegalArgumentException("Could not find slot with key: " + key);
        }

        private Layout findLayoutContainingSlotGroup(Layout.SlotGroupKey key) {
            for (Layout layout : this.layouts.keySet()) {
                Optional<SlotGroup> slotGroup = layout.slotGroup(key);
                if (!slotGroup.isPresent()) continue;
                return layout;
            }
            throw new IllegalArgumentException("Could not find slot group with key: " + key);
        }

        public Builder addLayout(Layout layout) {
            this.layouts.put(layout, true);
            return this;
        }

        public Builder addAllLayouts(Iterable<Layout> layouts) {
            layouts.forEach(this::addLayout);
            return this;
        }

        public Builder addOptionalLayout(Layout layout) {
            this.layouts.put(layout, false);
            return this;
        }

        public Builder addAllOptionalLayouts(Iterable<Layout> layouts) {
            layouts.forEach(this::addOptionalLayout);
            return this;
        }

        public Builder insertIntoSlot(Layout.SlotKey key, DisplayComponent ... components) {
            if (components.length == 0) {
                return this;
            }
            Layout layout = this.findLayoutContainingSlot(key);
            this.interactablesBuilder.add((Object)new InteractiveComponentGroup(layout.slot(key).get(), components));
            this.layouts.put(layout, true);
            this.slotInsertions.add((Object)key);
            return this;
        }

        public Builder insertIntoSlot(Layout.SlotKey key, Iterable<DisplayComponent> components) {
            if (Iterables.isEmpty(components)) {
                return this;
            }
            Layout layout = this.findLayoutContainingSlot(key);
            this.interactablesBuilder.add((Object)new InteractiveComponentGroup(layout.slot(key).get(), components));
            this.layouts.put(layout, true);
            this.slotInsertions.add((Object)key);
            return this;
        }

        public SlotGroupAutoSubBuilder autoInsertIntoSlotGroup(Layout.SlotGroupKey key) {
            if (this.slotGroupAutoSubBuilders.containsKey(key)) {
                return this.slotGroupAutoSubBuilders.get(key);
            }
            Layout layout = this.findLayoutContainingSlotGroup(key);
            SlotGroupAutoSubBuilder builder = new SlotGroupAutoSubBuilder(layout, key, layout.slotGroup(key).get());
            this.slotGroupAutoSubBuilders.put(key, builder);
            return builder;
        }

        public SlotGroupManualSubBuilder manualInsertIntoSlotGroup(Layout.SlotGroupKey key) {
            Layout layout = this.findLayoutContainingSlotGroup(key);
            return new SlotGroupManualSubBuilder(layout, key, layout.slotGroup(key).get());
        }

        public Builder addInteractable(Interactable interactable) {
            this.interactablesBuilder.add((Object)interactable);
            return this;
        }

        public Diagram build() {
            Layout.Builder layoutBuilder = Layout.builder();
            this.layouts.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(layoutBuilder::addSubLayout);
            Layout layout = layoutBuilder.build();
            this.interactablesBuilder.addAll(layout.interactables());
            return new Diagram(layout, this.slotInsertions, (ImmutableList<? extends Interactable>)this.interactablesBuilder.build());
        }

        public final class SlotGroupManualSubBuilder {
            private final Layout layout;
            private final Layout.SlotGroupKey slotGroupKey;
            private final SlotGroup slotGroup;

            private SlotGroupManualSubBuilder(Layout layout, Layout.SlotGroupKey slotGroupKey, SlotGroup slotGroup) {
                this.layout = layout;
                this.slotGroupKey = slotGroupKey;
                this.slotGroup = slotGroup;
            }

            public SlotGroupManualSubBuilder insertIntoSlot(int x, int y, DisplayComponent ... components) {
                Builder.this.interactablesBuilder.add((Object)new InteractiveComponentGroup(this.slotGroup.slot(x, y), components));
                Builder.this.layouts.put(this.layout, true);
                Builder.this.slotInsertions.add((Object)this.slotGroupKey);
                return this;
            }

            public SlotGroupManualSubBuilder insertIntoSlot(int x, int y, Iterable<DisplayComponent> components) {
                Builder.this.interactablesBuilder.add((Object)new InteractiveComponentGroup(this.slotGroup.slot(x, y), components));
                Builder.this.layouts.put(this.layout, true);
                Builder.this.slotInsertions.add((Object)this.slotGroupKey);
                return this;
            }
        }

        public final class SlotGroupAutoSubBuilder {
            private final Layout layout;
            private final Layout.SlotGroupKey slotGroupKey;
            private final Iterator<Slot> slotIterator;

            private SlotGroupAutoSubBuilder(Layout layout, Layout.SlotGroupKey slotGroupKey, SlotGroup slotGroup) {
                this.layout = layout;
                this.slotGroupKey = slotGroupKey;
                this.slotIterator = slotGroup.slots().iterator();
            }

            public SlotGroupAutoSubBuilder insertIntoNextSlot(DisplayComponent ... components) {
                if (components.length == 0) {
                    return this;
                }
                this.insertIntoSlot(this.slotIterator.next(), components);
                return this;
            }

            public SlotGroupAutoSubBuilder insertIntoNextSlot(Iterable<DisplayComponent> components) {
                if (Iterables.isEmpty(components)) {
                    return this;
                }
                this.insertIntoSlot(this.slotIterator.next(), components);
                return this;
            }

            public SlotGroupAutoSubBuilder insertEach(Iterable<DisplayComponent> components) {
                components.forEach(xva$0 -> this.insertIntoNextSlot((DisplayComponent)xva$0));
                return this;
            }

            public SlotGroupAutoSubBuilder insertEachSafe(Iterable<DisplayComponent> components) {
                Iterator<DisplayComponent> iterator = components.iterator();
                while (this.slotIterator.hasNext() && iterator.hasNext()) {
                    Slot slot = this.slotIterator.next();
                    if (this.slotIterator.hasNext()) {
                        this.insertIntoSlot(slot, iterator.next());
                        continue;
                    }
                    this.insertIntoSlot(slot, () -> iterator);
                }
                return this;
            }

            public SlotGroupAutoSubBuilder insertEachGroup(Iterable<? extends Iterable<DisplayComponent>> components) {
                components.forEach(this::insertIntoNextSlot);
                return this;
            }

            public <T extends Iterable<DisplayComponent>> SlotGroupAutoSubBuilder insertEachGroupSafe(Iterable<T> components) {
                Iterator iterator = StreamSupport.stream(components.spliterator(), false).filter(iter -> !Iterables.isEmpty((Iterable)iter)).iterator();
                while (this.slotIterator.hasNext() && iterator.hasNext()) {
                    Slot slot = this.slotIterator.next();
                    if (this.slotIterator.hasNext()) {
                        this.insertIntoSlot(slot, (Iterable)iterator.next());
                        continue;
                    }
                    this.insertIntoSlot(slot, Iterables.concat(() -> iterator));
                }
                return this;
            }

            private void insertIntoSlot(Slot slot, DisplayComponent ... components) {
                Builder.this.interactablesBuilder.add((Object)new InteractiveComponentGroup(slot, components));
                Builder.this.layouts.put(this.layout, true);
                Builder.this.slotInsertions.add((Object)this.slotGroupKey);
            }

            private void insertIntoSlot(Slot slot, Iterable<DisplayComponent> components) {
                Builder.this.interactablesBuilder.add((Object)new InteractiveComponentGroup(slot, components));
                Builder.this.layouts.put(this.layout, true);
                Builder.this.slotInsertions.add((Object)this.slotGroupKey);
            }
        }
    }
}

