/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bdew.neiaddons.NEIAddons;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;

public class ClientHandler
extends SimpleChannelInboundHandler<NBTTagCompound> {
    public static Set<String> enabledCommands = new HashSet<String>();

    public ClientHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void handleConnectEvent(FMLNetworkEvent.ClientConnectedToServerEvent ev) {
        NEIAddons.logInfo("Connected to new server, resetting commands", new Object[0]);
        enabledCommands.clear();
    }

    protected void channelRead0(ChannelHandlerContext ctx, NBTTagCompound msg) throws Exception {
        String cmd = msg.func_74779_i("cmd");
        NBTTagCompound data = msg.func_74775_l("data");
        try {
            if (cmd.equals("hello")) {
                NEIAddons.logInfo("Received handshake from server", new Object[0]);
                enabledCommands.clear();
                if (data.func_74762_e("version") != 1) {
                    NEIAddons.logWarning("Client/Server version mismatch! client=%d server=%d", data.func_74762_e("version"), 1);
                    return;
                }
                String cmds = data.func_74779_i("commands");
                NEIAddons.logInfo("Available server commands: %s", cmds);
                enabledCommands.addAll(Arrays.asList(StringUtils.split((String)cmds, (char)';')));
            } else {
                NEIAddons.logWarning("Uknown packet from server: %s", cmd);
            }
        }
        catch (Throwable e) {
            NEIAddons.logSevereExc(e, "Error handling packet from server", new Object[0]);
        }
    }
}

