/*
 * Decompiled with CFR 0.152.
 */
package mantle.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mantle.lib.CoreConfig;
import mantle.lib.CoreRepo;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingHandler {
    private static boolean ia1NG;

    public static void logConflicts() {
        if (CoreConfig.dumpRecipeConflicts) {
            for (Map.Entry<IRecipe, List<IRecipe>> me : CraftingHandler.getPotentialConflicts().entrySet()) {
                String s = "";
                for (IRecipe i : me.getValue()) {
                    s = s + CraftingHandler.print(i);
                }
                CoreRepo.logger.error("found conflict: \n" + s);
            }
        }
    }

    public static Map<IRecipe, List<IRecipe>> getPotentialConflicts() {
        CoreRepo.logger.info("dumping recipe conflicts to log this can take a while");
        HashMap conflicts = Maps.newHashMap();
        CraftingManager inst = CraftingManager.func_77594_a();
        List recipes = inst.func_77592_b();
        block0: for (IRecipe i : recipes) {
            for (int r = 0; r < recipes.size(); ++r) {
                List l;
                boolean comp;
                IRecipe rc = (IRecipe)recipes.get(r);
                if (i == null || rc == null || !(comp = CraftingHandler.compare(i, rc)) || CraftingHandler.areItemStacksEqual(i.func_77571_b(), rc.func_77571_b())) continue;
                if (conflicts.containsKey(i)) {
                    l = (List)conflicts.get(i);
                    conflicts.remove(i);
                    if (!l.contains(r)) {
                        l.add(recipes.get(r));
                    }
                    conflicts.put(i, l);
                } else if (conflicts.containsKey(rc)) {
                    l = (List)conflicts.get(rc);
                    conflicts.remove(rc);
                    if (!l.contains(i)) {
                        l.add(i);
                    }
                    conflicts.put(rc, l);
                } else {
                    l = Lists.newArrayList((Object[])new IRecipe[]{i, rc});
                    conflicts.put(i, l);
                }
                if (!ia1NG) continue;
                ia1NG = false;
                continue block0;
            }
        }
        return conflicts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean compare(IRecipe i1, IRecipe i2) {
        ItemStack is;
        int in;
        Object o;
        if (CraftingHandler.areItemStacksEqual(i1.func_77571_b(), i2.func_77571_b())) {
            return false;
        }
        boolean is1l = false;
        boolean is2l = false;
        ArrayList<ItemStack> il1 = Lists.newArrayList();
        ArrayList<ItemStack> il2 = Lists.newArrayList();
        ItemStack ia1 = null;
        boolean invalid = false;
        ItemStack[] ia2 = null;
        if (i1 instanceof ShapedRecipes) {
            ia1 = (ItemStack)((ShapedRecipes)i1).field_77574_d.clone();
        } else if (i1 instanceof ShapelessRecipes) {
            il1 = new ArrayList<ItemStack>(((ShapelessRecipes)i1).field_77579_b);
            is1l = true;
        } else if (i1 instanceof ShapedOreRecipe) {
            o = ((ShapedOreRecipe)i1).getInput();
            ia1 = new ItemStack[((Object[])o).length];
            for (in = 0; in < ((Object[])o).length; ++in) {
                ia1[in] = o[in] != null && o[in] instanceof ItemStack ? (ItemStack)o[in] : (o[in] != null ? (ItemStack)((ArrayList)o[in]).get(0) : null);
            }
        } else if (i1 instanceof ShapelessOreRecipe) {
            il1 = new ArrayList();
            for (Object o2 : ((ShapelessOreRecipe)i1).getInput()) {
                if (o2 != null && o2 instanceof ItemStack) {
                    is = (ItemStack)o2;
                    il1.add(is);
                    continue;
                }
                if (o2 != null) {
                    is = (ItemStack)((ArrayList)o2).get(0);
                    il1.add(is);
                    continue;
                }
                il1.add(null);
            }
            is1l = true;
        } else {
            ia1NG = true;
            invalid = true;
        }
        if (i2 instanceof ShapedRecipes) {
            ia2 = (ItemStack[])((ShapedRecipes)i2).field_77574_d.clone();
        } else if (i2 instanceof ShapelessRecipes) {
            il2 = new ArrayList<ItemStack>(((ShapelessRecipes)i2).field_77579_b);
            is2l = true;
        } else if (i2 instanceof ShapedOreRecipe) {
            o = ((ShapedOreRecipe)i2).getInput();
            ia2 = new ItemStack[((Object)o).length];
            for (in = 0; in < ((Object)o).length; ++in) {
                if (((Object)o).length == 6) {
                    CraftingHandler.print(i2);
                }
                ia2[in] = o[in] != null && o[in] instanceof ItemStack ? (ItemStack)o[in] : (o[in] != null ? (is = (ItemStack)((ArrayList)o[in]).get(0)) : null);
            }
        } else {
            if (!(i2 instanceof ShapelessOreRecipe)) return false;
            il2 = new ArrayList();
            for (Object o3 : ((ShapelessOreRecipe)i2).getInput()) {
                if (o3 != null && o3 instanceof ItemStack) {
                    is = (ItemStack)o3;
                    il2.add(is);
                    continue;
                }
                if (o3 != null) {
                    is = (ItemStack)((ArrayList)o3).get(0);
                    il2.add(is);
                    continue;
                }
                il2.add(null);
            }
            is2l = true;
        }
        if (invalid) return false;
        if (!is1l && !is2l) {
            if (ia1 == null) {
                CoreRepo.logger.error("ia1 null");
            }
            if (ia2 == null) {
                CoreRepo.logger.error("ia2 null");
            }
            if (((ItemStack[])ia1).length != ia2.length) {
                return false;
            }
            for (int i = 0; i < ((ItemStack[])ia1).length; ++i) {
                if (ia1[i] == null) return false;
                if (ia2[i] == null) return false;
                if (CraftingHandler.areItemStacksEqual(ia1[i], ia2[i])) continue;
                return false;
            }
        } else if (is1l && is2l) {
            if (il1.size() != il2.size()) return false;
            boolean has = false;
            block7: for (int i = 0; i < il1.size(); ++i) {
                ItemStack ti1 = (ItemStack)il1.get(i);
                for (int j = 0; j < il2.size(); ++j) {
                    if (!CraftingHandler.areItemStacksEqual(ti1, (ItemStack)il2.get(j))) continue;
                    il2.remove(j);
                    has = true;
                    continue block7;
                }
            }
            if (!has) {
                return false;
            }
            if (il2.size() != 0) {
                return false;
            }
        } else {
            ItemStack stcks;
            ArrayList<ItemStack> stacks = is1l ? il1 : il2;
            for (ItemStack i : stcks = is2l ? ia1 : ia2) {
                if (!stacks.contains(i)) {
                    return false;
                }
                stacks.remove(i);
            }
        }
        if (!(i1 instanceof ShapedOreRecipe)) return true;
        if (!(i2 instanceof ShapedOreRecipe)) return true;
        try {
            Class<ShapedOreRecipe> cl = ShapedOreRecipe.class;
            Field w = cl.getDeclaredField("width");
            w.setAccessible(true);
            Field h = cl.getDeclaredField("height");
            h.setAccessible(true);
            int i1w = (Integer)w.get((ShapedOreRecipe)i1);
            int i2w = (Integer)w.get((ShapedOreRecipe)i2);
            int i1h = (Integer)h.get((ShapedOreRecipe)i1);
            int i2h = (Integer)h.get((ShapedOreRecipe)i2);
            if (i1w != i2w) return false;
            if (i1h == i2h) return true;
            return false;
        }
        catch (Exception e) {
            CoreRepo.logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private static String print(IRecipe i1) {
        String out;
        block8: {
            block10: {
                block9: {
                    block7: {
                        out = "";
                        if (!(i1 instanceof ShapedRecipes)) break block7;
                        out = out + "SHAPED " + CraftingHandler.toStr(i1.func_77571_b()) + "\n";
                        for (ItemStack i : ((ShapedRecipes)i1).field_77574_d) {
                            out = i != null && i.func_77973_b() != null ? out + CraftingHandler.toStr(i) + "\n" : out + "null \n";
                        }
                        break block8;
                    }
                    if (!(i1 instanceof ShapelessRecipes)) break block9;
                    out = out + "SHAPELESS " + CraftingHandler.toStr(i1.func_77571_b()) + "\n";
                    for (Object i : ((ShapelessRecipes)i1).field_77579_b) {
                        if ((ItemStack)i != null && ((ItemStack)i).func_77973_b() != null) {
                            out = out + CraftingHandler.toStr((ItemStack)i) + "\n";
                            continue;
                        }
                        out = out + "null \n";
                    }
                    break block8;
                }
                if (!(i1 instanceof ShapedOreRecipe)) break block10;
                out = out + "SHAPED ORE  " + CraftingHandler.toStr(i1.func_77571_b()) + "\n";
                Object[] o = ((ShapedOreRecipe)i1).getInput();
                ItemStack[] ia1 = new ItemStack[o.length];
                for (int in = 0; in < o.length; ++in) {
                    ia1[in] = o[in] != null && o[in] instanceof ItemStack ? (ItemStack)o[in] : (o[in] != null ? (ItemStack)((ArrayList)o[in]).get(0) : null);
                }
                for (ItemStack i : ia1) {
                    out = i != null && i.func_77973_b() != null ? out + CraftingHandler.toStr(i) + "\n" : out + "null \n";
                }
                break block8;
            }
            if (!(i1 instanceof ShapelessOreRecipe)) break block8;
            out = out + "SHAPELESS ORE " + CraftingHandler.toStr(i1.func_77571_b()) + "\n";
            for (Object ob : ((ShapelessOreRecipe)i1).getInput()) {
                ItemStack i = ob instanceof ItemStack ? (ItemStack)ob : (ItemStack)((ArrayList)ob).get(0);
                if (i != null && i.func_77973_b() != null) {
                    out = out + CraftingHandler.toStr(i) + "\n";
                    continue;
                }
                out = out + "null \n";
            }
        }
        return out;
    }

    private static String toStr(ItemStack is) {
        return GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b()) + " " + is.toString();
    }

    public static boolean areItemStacksEqual(ItemStack a, ItemStack b) {
        if (!(a != null && b != null || a == null && b == null)) {
            return false;
        }
        if (a == null && b == null) {
            return true;
        }
        return a.field_77994_a != b.field_77994_a ? false : (a.func_77973_b() != b.func_77973_b() ? false : (CraftingHandler.compdamage(a, b) ? false : (a.field_77990_d == null && b.field_77990_d != null ? false : a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d))));
    }

    public static boolean compdamage(ItemStack a, ItemStack b) {
        return a.func_77960_j() != b.func_77960_j() || a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE;
    }
}

