/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.util;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.doubledoordev.itemblacklist.Helper;
import net.doubledoordev.itemblacklist.ItemBlacklist;
import net.doubledoordev.itemblacklist.data.GlobalBanList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ServerEventHandlers {
    public static final ServerEventHandlers I = new ServerEventHandlers();

    private ServerEventHandlers() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void multiPlaceEvent(BlockEvent.MultiPlaceEvent event) {
        EntityPlayer player = event.player;
        if (player == null || event.itemInHand == null) {
            return;
        }
        if (!Helper.shouldCare(event.player)) {
            return;
        }
        if (GlobalBanList.isBanned(player.field_71093_bK, event.itemInHand)) {
            player.func_146105_b((IChatComponent)new ChatComponentText(ItemBlacklist.message));
            if (ItemBlacklist.log) {
                ItemBlacklist.logger.info("{} tried to use {} at {};{};{} (Place Block. Banned Item in hand)", new Object[]{player.func_70005_c_(), player.func_70694_bm().func_82833_r(), event.x, event.y, event.z});
            }
            event.setCanceled(true);
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        } else {
            for (BlockSnapshot blockSnapshot : event.getReplacedBlockSnapshots()) {
                if (!GlobalBanList.isBanned(player.field_71093_bK, new ItemStack(blockSnapshot.getCurrentBlock(), 1, blockSnapshot.world.func_72805_g(event.x, event.y, event.z)))) continue;
                player.func_146105_b((IChatComponent)new ChatComponentText(ItemBlacklist.message));
                if (ItemBlacklist.log) {
                    ItemBlacklist.logger.info("{} tried to use {} at {};{};{} (Place Block. Banned Item placed.)", new Object[]{player.func_70005_c_(), player.func_70694_bm().func_82833_r(), event.x, event.y, event.z});
                }
                event.setCanceled(true);
                GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockPlaceEvent(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.player;
        if (player == null || event.itemInHand == null) {
            return;
        }
        if (!Helper.shouldCare(event.player)) {
            return;
        }
        if (GlobalBanList.isBanned(player.field_71093_bK, event.itemInHand)) {
            player.func_146105_b((IChatComponent)new ChatComponentText(ItemBlacklist.message));
            if (ItemBlacklist.log) {
                ItemBlacklist.logger.info("{} tried to use {} at {};{};{} (Place Block. Banned Item in hand)", new Object[]{player.func_70005_c_(), player.func_70694_bm().func_82833_r(), event.x, event.y, event.z});
            }
            event.setCanceled(true);
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        } else if (GlobalBanList.isBanned(player.field_71093_bK, new ItemStack(event.blockSnapshot.getCurrentBlock(), 1, event.blockSnapshot.world.func_72805_g(event.x, event.y, event.z)))) {
            player.func_146105_b((IChatComponent)new ChatComponentText(ItemBlacklist.message));
            if (ItemBlacklist.log) {
                ItemBlacklist.logger.info("{} tried to use {} at {};{};{} (Place Block. Banned Item placed.)", new Object[]{player.func_70005_c_(), player.func_70694_bm().func_82833_r(), event.x, event.y, event.z});
            }
            event.setCanceled(true);
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerInteractEvent(PlayerInteractEvent event) {
        if (event.entityPlayer.func_70694_bm() == null) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        if (!Helper.shouldCare(player)) {
            return;
        }
        if (GlobalBanList.isBanned(player.field_71093_bK, player.func_70694_bm())) {
            player.func_146105_b((IChatComponent)new ChatComponentText(ItemBlacklist.message));
            if (ItemBlacklist.log) {
                ItemBlacklist.logger.info("{} tried to use {} at {};{};{} ({})", new Object[]{player.func_70005_c_(), player.func_70694_bm().func_82833_r(), event.x, event.y, event.z, event.action});
            }
            event.setCanceled(true);
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!Helper.shouldCare(event.player)) {
            return;
        }
        GlobalBanList.process(event.toDim, (IInventory)event.player.field_71071_by);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void itemTossEvent(ItemTossEvent event) {
        if (!Helper.shouldCare(event.player)) {
            return;
        }
        event.entityItem.func_92058_a(GlobalBanList.process(event.player.field_71093_bK, event.entityItem.func_92059_d()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void entityItemPickupEvent(EntityItemPickupEvent event) {
        if (!Helper.shouldCare(event.entityPlayer)) {
            return;
        }
        event.item.func_92058_a(GlobalBanList.process(event.entityPlayer.field_71093_bK, event.item.func_92059_d()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerOpenContainerEvent(PlayerOpenContainerEvent event) {
        EntityPlayer player = event.entityPlayer;
        if (!Helper.shouldCare(event.entityPlayer)) {
            return;
        }
        if (player.getEntityData().func_74762_e("ItemBlacklist") != player.field_71070_bA.hashCode()) {
            player.getEntityData().func_74768_a("ItemBlacklist", player.field_71070_bA.hashCode());
            GlobalBanList.process(player.field_70170_p.field_73011_w.field_76574_g, player.field_71070_bA, player);
        }
    }
}

