/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.client;

import net.doubledoordev.itemblacklist.util.ItemBlacklisted;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class Renderer
implements IItemRenderer {
    private EntityItem entityItem;
    private RenderItem rendererItem;

    public Renderer() {
        this.entityItem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        this.rendererItem = new RenderItem(){

            public boolean shouldSpreadItems() {
                return false;
            }

            public boolean shouldBob() {
                return false;
            }
        };
        this.rendererItem.func_76976_a(RenderManager.field_78727_a);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (!ItemBlacklisted.canUnpack(item)) {
            return false;
        }
        ItemStack unpacked = ItemBlacklisted.unpack(item);
        if (unpacked == item) {
            return false;
        }
        IItemRenderer renderer = MinecraftForgeClient.getItemRenderer((ItemStack)unpacked, (IItemRenderer.ItemRenderType)type);
        if (renderer != null) {
            return renderer.handleRenderType(unpacked, type);
        }
        return unpacked.func_77973_b().func_94901_k() != ItemBlacklisted.I.func_94901_k();
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        ItemStack unpacked = ItemBlacklisted.unpack(item);
        if (unpacked == item) {
            return helper != IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK;
        }
        IItemRenderer renderer = MinecraftForgeClient.getItemRenderer((ItemStack)unpacked, (IItemRenderer.ItemRenderType)type);
        if (renderer != null) {
            return renderer.shouldUseRenderHelper(type, unpacked, helper);
        }
        return helper != IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        IItemRenderer renderer;
        ItemStack unpacked = ItemBlacklisted.unpack(item);
        if (unpacked == item) {
            return;
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY) {
            unpacked.field_77994_a = 1;
        }
        if ((renderer = MinecraftForgeClient.getItemRenderer((ItemStack)unpacked, (IItemRenderer.ItemRenderType)type)) != null) {
            renderer.renderItem(type, unpacked, data);
            return;
        }
        try {
            GL11.glPushMatrix();
            float scale = 4.0f;
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                scale = 4.0f;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-2.0f, (float)3.0f, (float)-3.0f);
                GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
                GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
                scale = 2.0f;
            } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
                GL11.glTranslatef((float)0.6f, (float)0.65f, (float)0.5f);
            } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
                GL11.glTranslatef((float)0.6f, (float)0.3f, (float)0.6f);
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            this.entityItem.func_92058_a(unpacked);
            RenderHelper.func_74519_b();
            this.rendererItem.func_76986_a(this.entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderHelper.func_74518_a();
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glDisable((int)2929);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().func_110434_K().func_130087_a(ItemBlacklisted.I.func_94901_k()));
                this.rendererItem.func_94149_a(0, 0, item.func_77954_c(), 16, 16);
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

