/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.api.ModifierLoader;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;

public class MM_Berserk
extends MobModifier {
    private static float damageMultiplier;
    private static float maxBerserkDamage;
    private static Class<?>[] disallowed;
    private static String[] suffix;
    private static String[] prefix;

    public MM_Berserk(@Nullable MobModifier next) {
        super("Berserk", next);
    }

    @Override
    public float onAttack(EntityLivingBase entity, DamageSource source, float damage) {
        if (entity != null) {
            source.func_76346_g().func_70097_a(DamageSource.field_76377_j, damage);
            damage = Math.min(maxBerserkDamage, damage * damageMultiplier);
        }
        return super.onAttack(entity, source, damage);
    }

    @Override
    public Class<?>[] getBlackListMobClasses() {
        return disallowed;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }

    static {
        disallowed = new Class[]{EntityCreeper.class};
        suffix = new String[]{"ofRecklessness", "theRaging", "ofSmashing"};
        prefix = new String[]{"reckless", "raging", "smashing"};
    }

    public static class Loader
    extends ModifierLoader<MM_Berserk> {
        public Loader() {
            super(MM_Berserk.class);
        }

        @Override
        public MM_Berserk make(@Nullable MobModifier next) {
            return new MM_Berserk(next);
        }

        @Override
        public void loadConfig(Configuration config) {
            damageMultiplier = (float)config.get(this.getModifierClassName(), "damageMultiplier", 2.0, "Damage multiplier, limited by maxOneShotDamage").getDouble(2.0);
            maxBerserkDamage = (float)config.get(this.getModifierClassName(), "berserkMaxDamage", 0.0, "Maximum amount of damage that a mob with Berserk can deal (0, or less than zero for unlimited berserk damage)").getDouble(0.0);
        }
    }
}

