/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.blocks.subblocks;

import ic2.api.tile.IWrenchable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import shedar.mods.ic2.nuclearcontrol.ITextureHelper;

public abstract class Subblock {
    protected int damage;
    protected String name;

    public Subblock(int damage, String name) {
        this.damage = damage;
        this.name = name;
    }

    public int getDamage() {
        return this.damage;
    }

    public String getName() {
        return this.name;
    }

    public IIcon getBlockTextureFromSide(int side) {
        return this.getIcon(this.getMapping()[0][side]);
    }

    public IIcon getBlockTexture(IBlockAccess blockaccess, int x, int y, int z, int side) {
        TileEntity tileentity = blockaccess.func_147438_o(x, y, z);
        int metaSide = 0;
        if (tileentity instanceof IWrenchable) {
            metaSide = Facing.field_71588_a[((IWrenchable)tileentity).getFacing()];
        }
        int texture = this.getMapping()[metaSide][side];
        if (tileentity instanceof ITextureHelper) {
            texture = ((ITextureHelper)tileentity).modifyTextureIndex(texture);
        }
        return this.getIcon(texture);
    }

    public abstract IIcon getIcon(int var1);

    protected abstract byte[][] getMapping();

    public abstract void registerIcons(IIconRegister var1);

    public abstract TileEntity getTileEntity();

    public abstract boolean isSolidBlockRequired();

    public abstract boolean hasGui();

    public abstract float[] getBlockBounds(TileEntity var1);

    public abstract Container getServerGuiElement(TileEntity var1, EntityPlayer var2);

    public abstract Object getClientGuiElement(TileEntity var1, EntityPlayer var2);
}

