/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.item.ItemKnowledgeNote;
import chylex.hee.item.ItemMusicDisk;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.loot.IItemPostProcessor;
import chylex.hee.world.loot.LootItemStack;
import chylex.hee.world.loot.WeightedLootList;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumChatFormatting;

public class StructureSilverfishDungeon
extends AbstractIslandStructure
implements ITileEntityGenerator {
    public static WeightedLootList lootDungeon = new WeightedLootList(new LootItemStack(Items.field_151121_aF).setAmount(1, 11).setWeight(36), new LootItemStack(Items.field_151122_aG).setAmount(1, 8).setWeight(25), new LootItemStack((Item)Items.field_151134_bR).setWeight(17), new LootItemStack(Items.field_151007_F).setAmount(1, 4).setWeight(15), new LootItemStack(Items.field_151116_aA).setAmount(1, 4).setWeight(12), new LootItemStack(Items.field_151174_bG).setAmount(1, 3).setWeight(11), new LootItemStack(Items.field_151100_aR).setDamage(15).setWeight(8), new LootItemStack(Items.field_151170_bI).setAmount(1, 4).setWeight(6), new LootItemStack(Items.field_151078_bh).setAmount(1, 5).setWeight(6), new LootItemStack(Blocks.field_150325_L).setAmount(1, 3).setDamage(0, 15).setWeight(6), new LootItemStack(ItemList.knowledge_note).setWeight(5), new LootItemStack(Items.field_151076_bf).setAmount(1, 3).setWeight(5), new LootItemStack(Items.field_151147_al).setAmount(1, 3).setWeight(4), new LootItemStack((Item)Items.field_151024_Q).setWeight(4), new LootItemStack((Item)Items.field_151027_R).setWeight(4), new LootItemStack((Item)Items.field_151026_S).setWeight(4), new LootItemStack((Item)Items.field_151021_T).setWeight(4), new LootItemStack(Items.field_151082_bd).setAmount(1, 3).setWeight(3), new LootItemStack(Items.field_151102_aT).setAmount(1, 2).setWeight(3), new LootItemStack(ItemList.music_disk).setDamage(0, ItemMusicDisk.getRecordCount() - 1).setWeight(2)).addItemPostProcessor(new IItemPostProcessor(){

        @Override
        public ItemStack processItem(ItemStack is, Random rand) {
            if (is.func_77975_n() == EnumAction.eat) {
                ItemUtil.addLore(is, EnumChatFormatting.DARK_PURPLE.toString() + EnumChatFormatting.ITALIC + "It smells fishy...");
            } else if (is.func_77973_b() == Items.field_151134_bR) {
                is.func_150996_a(Items.field_151122_aG);
                EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)is, (int)(13 + rand.nextInt(7)));
            } else if (is.func_77956_u() && is.func_77973_b() != Items.field_151122_aG) {
                if (rand.nextInt(4) != 0) {
                    EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)is, (int)(16 + rand.nextInt(5)));
                }
                ItemUtil.setArmorColor(is, rand.nextInt(0x1000000));
            } else if (is.func_77973_b() == ItemList.knowledge_note) {
                ItemKnowledgeNote.setRandomNote(is, rand, 5);
            }
            return is;
        }
    });

    @Override
    protected boolean generate(Random rand) {
        int x = this.getRandomXZ(rand, 8);
        int z = this.getRandomXZ(rand, 8);
        for (int attempt = 0; attempt < 300; ++attempt) {
            int y = 10 + rand.nextInt(45);
            boolean canSpawn = true;
            for (int testY = y - 1; testY > y - 5; --testY) {
                for (int testX = x - 3; testX <= x + 3; ++testX) {
                    if (!this.world.isAir(testX, testY, z)) continue;
                    canSpawn = false;
                    break;
                }
                for (int testZ = z - 3; testZ <= z + 3; ++testZ) {
                    if (!this.world.isAir(x, testY, testZ)) continue;
                    canSpawn = false;
                    break;
                }
                if (!canSpawn) break;
            }
            if (!canSpawn || this.world.isAir(x - 2, y, z - 2) || this.world.isAir(x - 2, y, z + 2) || this.world.isAir(x + 2, y, z - 2) || this.world.isAir(x + 2, y, z + 2)) continue;
            double rx = 3.5 + rand.nextDouble() * 1.5;
            double ry = 2.4 + rand.nextDouble() * 0.6;
            double rz = 3.5 + rand.nextDouble() * 1.5;
            int lowestY = 999;
            int ix = (int)((double)x - rx - 1.0);
            while ((double)ix <= (double)x + rx + 1.0) {
                int iy = (int)((double)y - ry - 1.0);
                while ((double)iy <= (double)y + ry + 1.0) {
                    int iz = (int)((double)z - rz - 1.0);
                    while ((double)iz <= (double)z + rz + 1.0) {
                        if ((double)MathUtil.square(x - ix) / (rx * rx) + (double)MathUtil.square(y - iy) / (ry * ry) + (double)MathUtil.square(z - iz) / (rz * rz) <= 0.9 + rand.nextDouble() * 0.2) {
                            this.world.setBlock(ix, iy, iz, Blocks.field_150350_a);
                            if (iy < lowestY) {
                                lowestY = iy;
                            }
                        }
                        ++iz;
                    }
                    ++iy;
                }
                ++ix;
            }
            int attempts = 70 + (int)(rand.nextDouble() * rand.nextDouble() * 75.0);
            for (int a = 0; a < attempts; ++a) {
                int iz;
                int iy;
                int ix2 = x + rand.nextInt(11) - 5;
                if (this.world.getBlock(ix2, iy = y + 1 - rand.nextInt(5), iz = z + rand.nextInt(11) - 5) != Blocks.field_150377_bs || !this.world.isAir(ix2, iy + 1, iz)) continue;
                this.world.setBlock(ix2, iy, iz, Blocks.field_150417_aV, rand.nextInt(3));
            }
            this.world.setBlock(x, lowestY, z, BlockList.custom_spawner, 1);
            if (rand.nextInt(5) <= 1) {
                for (int nextSpawnerAttempt = 0; nextSpawnerAttempt < 10; ++nextSpawnerAttempt) {
                    int spawnerZ;
                    int spawnerY;
                    int spawnerX = x + rand.nextInt(11) - 5;
                    if (!this.world.isAir(spawnerX, spawnerY = y + rand.nextInt(7) - 5, spawnerZ = z + rand.nextInt(11) - 5) || !this.world.isAir(spawnerX, spawnerY + 1, spawnerZ) || this.world.isAir(spawnerX, spawnerY - 1, spawnerZ)) continue;
                    this.world.setBlock(spawnerX, spawnerY, spawnerZ, BlockList.custom_spawner, 1);
                    break;
                }
            }
            boolean placedChest = false;
            int chestX = 0;
            int chestY = 0;
            int chestZ = 0;
            for (int chestAttempt = 0; chestAttempt < 40; ++chestAttempt) {
                chestX = x + rand.nextInt(11) - 5;
                if (!this.world.isAir(chestX, chestY = y + rand.nextInt(5) - 3, chestZ = z + rand.nextInt(11) - 5) || !this.world.isAir(chestX, chestY + 1, chestZ) || this.world.isAir(chestX, chestY - 1, chestZ)) continue;
                placedChest = true;
                break;
            }
            if (!placedChest) {
                chestX = x;
                chestY = lowestY + 1;
                chestZ = z;
            }
            this.world.setBlock(chestX, chestY, chestZ, (Block)Blocks.field_150486_ae, 0);
            this.world.setTileEntityGenerator(chestX, chestY, chestZ, "silverfishDungeonChest", this);
            break;
        }
        return true;
    }

    @Override
    public void onTileEntityRequested(String key, TileEntity tile, Random rand) {
        if (key.equals("silverfishDungeonChest") && tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            for (int a = 0; a < 7 + rand.nextInt(4) + rand.nextInt(6); ++a) {
                chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), lootDungeon.generateIS(rand));
            }
        }
    }
}

