/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.generators;

import chylex.hee.system.util.DragonUtil;
import chylex.hee.world.feature.blobs.BlobGenerator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.Random;
import net.minecraft.util.Vec3;

public class BlobGeneratorFromCenter
extends BlobGenerator {
    private IRandomAmount amountGen = IRandomAmount.exact;
    private byte minAmount;
    private byte maxAmount;
    private double minRad;
    private double maxRad;
    private double minDist;
    private double maxDist;
    private boolean unifiedSize;
    private boolean limitDist;

    public BlobGeneratorFromCenter(int weight) {
        super(weight);
    }

    public BlobGeneratorFromCenter amount(IRandomAmount amountGen, int minAmount, int maxAmount) {
        this.amountGen = amountGen;
        this.minAmount = (byte)minAmount;
        this.maxAmount = (byte)maxAmount;
        return this;
    }

    public BlobGeneratorFromCenter rad(double minRad, double maxRad) {
        this.minRad = minRad;
        this.maxRad = maxRad;
        return this;
    }

    public BlobGeneratorFromCenter dist(double minDist, double maxDist) {
        this.minDist = minDist;
        this.maxDist = maxDist;
        return this;
    }

    public BlobGeneratorFromCenter unifySize() {
        this.unifiedSize = true;
        return this;
    }

    public BlobGeneratorFromCenter limitDist() {
        this.limitDist = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        double rad = this.minRad + rand.nextDouble() * (this.maxRad - this.minRad);
        double firstDist = 0.0;
        int amt = this.amountGen.generate(rand, this.minAmount, this.maxAmount);
        for (int a = 0; a < amt; ++a) {
            double dist;
            Vec3 vec = a == 0 ? Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0) : DragonUtil.getRandomVector(rand);
            double d = dist = a == 0 ? 0.0 : this.minDist + rand.nextDouble() * (this.maxDist - this.minDist);
            if (this.limitDist) {
                if (a == 0) {
                    firstDist = rad;
                } else {
                    dist *= firstDist / this.maxDist;
                }
            }
            BlobGeneratorFromCenter.genBlob(gen, vec.field_72450_a * dist, vec.field_72448_b * dist, vec.field_72449_c * dist, rad);
            if (a > amt - 1 || this.unifiedSize) continue;
            rad = this.minRad + rand.nextDouble() * (this.maxRad - this.minRad);
        }
    }
}

