/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.render.texture;

import chylex.hee.item.ItemBiomeCompass;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class TextureBiomeCompass
extends TextureAtlasSprite {
    public double currentAngle;
    public double angleDelta;
    private double lastSavedX;
    private double lastSavedZ;
    private ChunkCoordinates cachedCoords;
    private byte cachedBiomeId;

    public TextureBiomeCompass(String iconName) {
        super(iconName);
    }

    public void func_94219_l() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            this.updateCompass((World)mc.field_71441_e, mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, mc.field_71439_g.field_70177_z, false, false);
        } else {
            this.updateCompass(null, 0.0, 0.0, 0.0, true, false);
            this.lastSavedZ = 0.0;
            this.lastSavedX = 0.0;
            this.cachedCoords = null;
        }
    }

    public void updateCompass(World world, double x, double z, double yaw, boolean isInMenu, boolean isItemFrame) {
        if (!this.field_110976_a.isEmpty()) {
            double angle = 0.0;
            if (world != null && !isInMenu) {
                if (this.lastSavedX == 0.0 && this.lastSavedZ == 0.0) {
                    this.lastSavedX = x;
                    this.lastSavedZ = z;
                    this.cachedCoords = null;
                } else if (this.cachedBiomeId != ItemBiomeCompass.currentBiome) {
                    this.cachedBiomeId = ItemBiomeCompass.currentBiome;
                    this.cachedCoords = null;
                } else if (MathUtil.square(x - this.lastSavedX) + MathUtil.square(z - this.lastSavedZ) > 230.0) {
                    this.cachedCoords = null;
                }
                if (this.cachedCoords == null && this.cachedBiomeId != -1 && !ItemBiomeCompass.locations.isEmpty()) {
                    Set<ChunkCoordinates> coords = ItemBiomeCompass.locations.get(this.cachedBiomeId);
                    double minDist = Double.MAX_VALUE;
                    for (ChunkCoordinates coord : coords) {
                        if (minDist == Double.MAX_VALUE) {
                            this.cachedCoords = coord;
                            minDist = MathUtil.square((double)coord.field_71574_a - x) + MathUtil.square((double)coord.field_71573_c - z);
                            continue;
                        }
                        double dist = MathUtil.square((double)coord.field_71574_a - x) + MathUtil.square((double)coord.field_71573_c - z);
                        if (!(dist < minDist)) continue;
                        this.cachedCoords = coord;
                        minDist = dist;
                    }
                    this.lastSavedX = x;
                    this.lastSavedZ = z;
                }
                angle = this.cachedCoords == null || world.field_73011_w.field_76574_g != 1 ? Math.random() * Math.PI * 2.0 : -(((yaw %= 360.0) - 90.0) * Math.PI / 180.0 - Math.atan2((double)this.cachedCoords.field_71573_c - z, (double)this.cachedCoords.field_71574_a - x));
            }
            if (isItemFrame) {
                this.currentAngle = angle;
            } else {
                double targetDelta;
                for (targetDelta = angle - this.currentAngle; targetDelta < -Math.PI; targetDelta += Math.PI * 2) {
                }
                while (targetDelta >= Math.PI) {
                    targetDelta -= Math.PI * 2;
                }
                targetDelta = MathUtil.clamp(targetDelta, -1.0, 1.0);
                this.angleDelta += targetDelta * 0.1;
                this.angleDelta *= 0.8;
                this.currentAngle += this.angleDelta;
            }
            int framesPerBiome = 32;
            int frame = (int)((this.currentAngle / (Math.PI * 2) + 1.0) * 32.0) % 32;
            while (frame < 0) {
                frame = (frame + 32) % 32;
            }
            if (frame != this.field_110973_g) {
                this.field_110973_g = frame + 32 * this.cachedBiomeId;
                TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(this.field_110973_g)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }
}

