/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.content.fragments;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.content.fragments.KnowledgeFragmentCrafting;
import chylex.hee.mechanics.compendium.content.fragments.KnowledgeFragmentText;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.util.KnowledgeUtils;
import chylex.hee.mechanics.enhancements.IEnhancementEnum;
import chylex.hee.system.util.DragonUtil;
import com.google.common.base.Joiner;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class KnowledgeFragmentEnhancement
extends KnowledgeFragment {
    private static final Set<KnowledgeFragmentEnhancement> enhancementFragments = new HashSet<KnowledgeFragmentEnhancement>();
    private IEnhancementEnum enhancement;
    private String name;

    public static final KnowledgeFragmentEnhancement getEnhancementFragment(IEnhancementEnum enhancement) {
        for (KnowledgeFragmentEnhancement fragment : enhancementFragments) {
            if (fragment.enhancement != enhancement) continue;
            return fragment;
        }
        return null;
    }

    public KnowledgeFragmentEnhancement(int globalID) {
        super(globalID);
        enhancementFragments.add(this);
    }

    public KnowledgeFragmentEnhancement setEnhancement(IEnhancementEnum enhancement) {
        this.enhancement = enhancement;
        this.name = DragonUtil.stripChatFormatting(enhancement.getName());
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getHeight(GuiEnderCompendium gui, boolean isUnlocked) {
        return 20;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClick(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, int buttonId, boolean isUnlocked) {
        if (isUnlocked && buttonId == 0 && mouseX >= x && mouseX <= x + 17 && mouseY >= y && mouseY <= y + 17) {
            KnowledgeObject<? extends IKnowledgeObjectInstance<?>> obj = KnowledgeUtils.tryGetFromItemStack(this.enhancement.getItemSelector().getRepresentativeItem());
            if (obj == null) {
                return false;
            }
            gui.showObject(obj);
            gui.moveToCurrentObject(true);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRender(GuiEnderCompendium gui, int x, int y, int mouseX, int mouseY, boolean isUnlocked) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack is = isUnlocked ? this.enhancement.getItemSelector().getRepresentativeItem() : KnowledgeFragmentCrafting.lockedItem;
        GuiItemRenderHelper.renderItemIntoGUI(gui.field_146297_k.func_110434_K(), is, x + 1, y + 1);
        RenderHelper.func_74518_a();
        KnowledgeFragmentText.renderString(this.name, x + 22, y + 5, 8519935, 8519935, gui);
        if (isUnlocked && mouseX >= x && mouseX <= x + 17 && mouseY >= y && mouseY <= y + 17) {
            GuiItemRenderHelper.setupTooltip(mouseX, mouseY, Joiner.on((char)'\n').join(KnowledgeUtils.getCompendiumTooltip(is, (EntityPlayer)gui.field_146297_k.field_71439_g)));
        }
    }
}

