/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.charms;

import chylex.hee.mechanics.charms.RuneType;
import gnu.trove.iterator.TObjectByteIterator;
import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CharmRecipe {
    public final byte id;
    private final TObjectByteHashMap<RuneType> runes = new TObjectByteHashMap();
    private final TObjectFloatHashMap<String> properties = new TObjectFloatHashMap();
    private byte runeAmount;

    public CharmRecipe(int id) {
        this.id = (byte)id;
    }

    public CharmRecipe rune(RuneType rune) {
        return this.rune(rune, 1);
    }

    public CharmRecipe rune(RuneType rune, int amount) {
        if (this.runes.containsKey((Object)rune)) {
            this.runeAmount = (byte)(this.runeAmount - this.runes.remove((Object)rune));
        }
        this.runes.put((Object)rune, (byte)amount);
        this.runeAmount = (byte)(this.runeAmount + amount);
        return this;
    }

    public CharmRecipe prop(String name, float value) {
        this.properties.put((Object)name, value);
        return this;
    }

    public float getProp(String name) {
        return this.properties.containsKey((Object)name) ? this.properties.get((Object)name) : -1.0f;
    }

    public boolean checkRunes(RuneType[] runes) {
        if (runes.length != this.runeAmount) {
            return false;
        }
        ArrayList<RuneType> runeList = new ArrayList<RuneType>();
        for (RuneType rune : runes) {
            runeList.add(rune);
        }
        TObjectByteIterator iter = this.runes.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int total = iter.value();
            for (int amt = 0; amt < total; ++amt) {
                if (runeList.remove(iter.key())) continue;
                return false;
            }
        }
        return runeList.isEmpty();
    }

    public Map<RuneType, Byte> getRunes() {
        HashMap<RuneType, Byte> runes = new HashMap<RuneType, Byte>();
        for (RuneType type : this.runes.keySet()) {
            runes.put(type, this.runes.get((Object)type));
        }
        return runes;
    }
}

