/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.general.ItemGenericChemBase;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.GT_MetaTileEntity_Hatch_MillingBalls;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GregtechMetaTileEntity_IsaMill
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IsaMill>
implements ISurvivalConstructable {
    protected boolean boostEu = false;
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_IsaMill> STRUCTURE_DEFINITION = null;
    private static final IIconContainer frontFaceActive = new TexturesGtBlock.CustomIcon("iconsets/Grinder/GRINDER_ACTIVE5");
    private static final IIconContainer frontFace = new TexturesGtBlock.CustomIcon("iconsets/Grinder/GRINDER5");
    private final ArrayList<GT_MetaTileEntity_Hatch_MillingBalls> mMillingBallBuses = new ArrayList();
    private static final DamageSource mIsaMillDamageSource = new DamageSource("gtpp.grinder").func_76348_h();
    private final AutoMap<BlockPos> mFrontBlockPosCache = new AutoMap();

    public GregtechMetaTileEntity_IsaMill(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IsaMill(String aName) {
        super(aName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Large Grinding Machine").addInfo("Grind ores.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 7, false).addController("Front Center").addCasingInfoMin("IsaMill Exterior Casing", 40, false).addOtherStructurePart("IsaMill Gearbox", "5x, Inner Blocks").addOtherStructurePart("IsaMill Piping", "8x, ring around controller").addStructureInfo("IsaMill Pipings must not be obstructed in front (only air blocks)").addOtherStructurePart("Milling Ball Hatch", "Any Casing").addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IsaMill> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"DDD", "CCC", "CCC", "CCC", "CCC", "CCC", "CCC"}, {"D~D", "CGC", "CGC", "CGC", "CGC", "CGC", "CCC"}, {"DDD", "CCC", "CCC", "CCC", "CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IsaMill.class).adder(GregtechMetaTileEntity_IsaMill::addMillingBallsHatch).hatchClass(GT_MetaTileEntity_Hatch_MillingBalls.class).shouldReject(t -> !t.mMillingBallBuses.isEmpty()).casingIndex((int)this.getCasingTextureIndex()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IsaMill.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex((int)this.getCasingTextureIndex()).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta()))})).addElement('D', StructureUtility.ofBlock((Block)this.getIntakeBlock(), (int)this.getIntakeMeta())).addElement('G', StructureUtility.ofBlock((Block)this.getGearboxBlock(), (int)this.getGearboxMeta())).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mMillingBallBuses.clear();
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 40 && this.checkHatch();
    }

    @Override
    public boolean checkHatch() {
        return super.checkHatch() && this.mMillingBallBuses.size() == 1;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return frontFaceActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return frontFace;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(2);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    private boolean addMillingBallsHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_MillingBalls) {
            return this.addToMachineListInternal(this.mMillingBallBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_MillingBalls) {
            this.log("Found GT_MetaTileEntity_Hatch_MillingBalls");
            return this.addToMachineListInternal(this.mMillingBallBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sOreMillRecipes;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mMillingBallBuses.clear();
        }
        if (aTick % 20L == 0L && this.isMachineRunning()) {
            this.checkForEntities(aBaseMetaTileEntity, aTick);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public void checkForEntities(IGregTechTileEntity aBaseMetaTileEntity, long aTime) {
        AutoMap<EntityLivingBase> aEntities;
        if (aTime % 100L == 0L) {
            this.mFrontBlockPosCache.clear();
        }
        if (this.mFrontBlockPosCache.isEmpty()) {
            ForgeDirection tSide = aBaseMetaTileEntity.getBackFacing();
            int aTileX = aBaseMetaTileEntity.getXCoord();
            short aTileY = aBaseMetaTileEntity.getYCoord();
            int aTileZ = aBaseMetaTileEntity.getZCoord();
            boolean xFacing = tSide.offsetX != 0;
            boolean zFacing = tSide.offsetZ != 0;
            int aDepthOffset = tSide == ForgeDirection.NORTH || tSide == ForgeDirection.WEST ? 1 : -1;
            for (int aHorizontalOffset = -1; aHorizontalOffset < 2; ++aHorizontalOffset) {
                for (int aVerticalOffset = -1; aVerticalOffset < 2; ++aVerticalOffset) {
                    int aX = !xFacing ? aTileX + aHorizontalOffset : aTileX + aDepthOffset;
                    int aY = aTileY + aVerticalOffset;
                    int aZ = !zFacing ? aTileZ + aHorizontalOffset : aTileZ + aDepthOffset;
                    this.mFrontBlockPosCache.add(new BlockPos(aX, aY, aZ, aBaseMetaTileEntity.getWorld()));
                }
            }
        }
        if (!(aEntities = GregtechMetaTileEntity_IsaMill.getEntities(this.mFrontBlockPosCache, aBaseMetaTileEntity.getWorld())).isEmpty()) {
            for (EntityLivingBase aFoundEntity : aEntities) {
                if (aFoundEntity instanceof EntityPlayer) {
                    EntityPlayer aPlayer = (EntityPlayer)aFoundEntity;
                    if (PlayerUtils.isCreative(aPlayer) || !PlayerUtils.canTakeDamage(aPlayer) || !(aFoundEntity.func_110143_aJ() > 0.0f)) continue;
                    EntityUtils.doDamage((Entity)aFoundEntity, mIsaMillDamageSource, this.getPlayerDamageValue(aPlayer, 10));
                    if (!aBaseMetaTileEntity.isClientSide() || !aBaseMetaTileEntity.isActive()) continue;
                    GregtechMetaTileEntity_IsaMill.generateParticles(aFoundEntity);
                    continue;
                }
                if (!(aFoundEntity.func_110143_aJ() > 0.0f)) continue;
                EntityUtils.doDamage((Entity)aFoundEntity, mIsaMillDamageSource, Math.max(1, (int)(aFoundEntity.func_110138_aP() / 3.0f)));
                if (!aBaseMetaTileEntity.isClientSide() || !aBaseMetaTileEntity.isActive()) continue;
                GregtechMetaTileEntity_IsaMill.generateParticles(aFoundEntity);
            }
        }
    }

    private int getPlayerDamageValue(EntityPlayer player, int damage) {
        int armorValue = player.func_70658_aO();
        int reducedDamage = (int)((double)damage - (double)damage * ((double)armorValue * 0.04));
        return Math.max(reducedDamage, 0);
    }

    private static final AutoMap<EntityLivingBase> getEntities(AutoMap<BlockPos> aPositionsToCheck, World aWorld) {
        AutoMap<EntityLivingBase> aEntities = new AutoMap<EntityLivingBase>();
        HashSet<Chunk> aChunksToCheck = new HashSet<Chunk>();
        if (!aPositionsToCheck.isEmpty()) {
            for (BlockPos aPos : aPositionsToCheck) {
                Chunk aLocalChunk = aWorld.func_72938_d(aPos.xPos, aPos.zPos);
                aChunksToCheck.add(aLocalChunk);
            }
        }
        if (!aChunksToCheck.isEmpty()) {
            AutoMap<EntityLivingBase> aEntitiesFound = new AutoMap<EntityLivingBase>();
            for (Chunk aChunk : aChunksToCheck) {
                if (!aChunk.field_76636_d) continue;
                List[] aEntityLists = aChunk.field_76645_j;
                for (List aEntitySubList : aEntityLists) {
                    Iterator iterator = aEntitySubList.iterator();
                    while (iterator.hasNext()) {
                        Object aEntity = iterator.next();
                        if (!(aEntity instanceof EntityLivingBase)) continue;
                        EntityLivingBase aPlayer = (EntityLivingBase)aEntity;
                        aEntitiesFound.add(aPlayer);
                    }
                }
            }
            if (!aEntitiesFound.isEmpty()) {
                for (EntityLivingBase aEntity : aEntitiesFound) {
                    BlockPos aPlayerPos = EntityUtils.findBlockPosOfEntity((Entity)aEntity);
                    for (BlockPos aBlockSpaceToCheck : aPositionsToCheck) {
                        if (!aBlockSpaceToCheck.equals(aPlayerPos)) continue;
                        aEntities.add(aEntity);
                    }
                }
            }
        }
        return aEntities;
    }

    private static void generateParticles(EntityLivingBase aEntity) {
        BlockPos aPlayerPosBottom = EntityUtils.findBlockPosOfEntity((Entity)aEntity);
        BlockPos aPlayerPosTop = aPlayerPosBottom.getUp();
        AutoMap<BlockPos> aEntityPositions = new AutoMap<BlockPos>();
        aEntityPositions.add(aPlayerPosBottom);
        aEntityPositions.add(aPlayerPosTop);
        for (int i = 0; i < 64; ++i) {
            BlockPos aEffectPos = (BlockPos)aEntityPositions.get(aEntity.field_70131_O > 1.0f ? MathUtils.randInt(0, 1) : 0);
            float aOffsetX = MathUtils.randFloat(-0.35f, 0.35f);
            float aOffsetY = MathUtils.randFloat(-0.25f, 0.35f);
            float aOffsetZ = MathUtils.randFloat(-0.35f, 0.35f);
            aEntity.field_70170_p.func_72869_a("reddust", (double)((float)aEffectPos.xPos + aOffsetX), (double)((float)aEffectPos.yPos + 0.3f + aOffsetY), (double)((float)aEffectPos.zPos + aOffsetZ), 0.0, 0.0, 0.0);
        }
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getCasingMeta() {
        return 0;
    }

    public Block getIntakeBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getIntakeMeta() {
        return 1;
    }

    public Block getGearboxBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getGearboxMeta() {
        return 2;
    }

    public byte getCasingTextureIndex() {
        return 66;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IsaMill(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIsaMill;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"IsaMill Grinding Machine", "Current Efficiency: " + this.mEfficiency / 100 + "%", this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String getMachineType() {
        return "Grinding Machine";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList tItems = super.getStoredInputs();
        for (GT_MetaTileEntity_Hatch_MillingBalls tHatch : this.mMillingBallBuses) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMetaTileEntity_IsaMill.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tItems.addAll(tHatch.getContentUsageSlots());
        }
        return tItems;
    }

    public int getMaxBallDurability(ItemStack aStack) {
        return ItemGenericChemBase.getMaxBallDurability(aStack);
    }

    private ItemStack findMillingBall(ItemStack[] aItemInputs) {
        AutoMap<ItemStack> aAvailableItems;
        if (this.mMillingBallBuses.size() != 1) {
            return null;
        }
        GT_MetaTileEntity_Hatch_MillingBalls aBus = this.mMillingBallBuses.get(0);
        if (aBus != null && !(aAvailableItems = aBus.getContentUsageSlots()).isEmpty()) {
            for (ItemStack aInput : aItemInputs) {
                if (!ItemUtils.isMillingBall(aInput)) continue;
                for (ItemStack aBall : aAvailableItems) {
                    if (!GT_Utility.areStacksEqual((ItemStack)aBall, (ItemStack)aInput, (boolean)true)) continue;
                    Logger.INFO("Found a valid milling ball to use.");
                    return aBall;
                }
            }
        }
        return null;
    }

    private void damageMillingBall(ItemStack aStack) {
        if ((double)(MathUtils.randFloat(0.0f, 1.0E7f) / 1.0E7f) < 1.0000000476837159) {
            int damage = this.getMillingBallDamage(aStack) + 1;
            this.log("damage milling ball " + damage);
            if (damage >= this.getMaxBallDurability(aStack)) {
                this.log("consuming milling ball");
                --aStack.field_77994_a;
            } else {
                this.setDamage(aStack, damage);
            }
        } else {
            this.log("not damaging milling ball");
        }
    }

    private int getMillingBallDamage(ItemStack aStack) {
        return ItemGenericChemBase.getMillingBallDamage(aStack);
    }

    private void setDamage(ItemStack aStack, int aAmount) {
        ItemGenericChemBase.setMillingBallDamage(aStack, aAmount);
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            ItemStack millingBall;

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                this.millingBall = GregtechMetaTileEntity_IsaMill.this.findMillingBall(this.inputItems);
                if (this.millingBall == null) {
                    return SimpleCheckRecipeResult.ofFailure((String)"no_milling_ball");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (result.wasSuccessful()) {
                    GregtechMetaTileEntity_IsaMill.this.damageMillingBall(this.millingBall);
                }
                return result;
            }
        };
    }
}

