/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import cpw.mods.fml.common.registry.LanguageRegistry;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class LangUtils {
    private static final Map<String, String> mLocaleCache = new HashMap<String, String>();

    public static boolean rewriteEntryForLanguageRegistry(String aKey, String aNewValue) {
        return LangUtils.rewriteEntryForLanguageRegistry("en_US", aKey, aNewValue);
    }

    public static boolean rewriteEntryForLanguageRegistry(String aLang, String aKey, String aNewValue) {
        LanguageRegistry aInstance = LanguageRegistry.instance();
        Field aModLanguageData = ReflectionUtils.getField(LanguageRegistry.class, "modLanguageData");
        if (aModLanguageData != null) {
            Map<String, Properties> aProps = new HashMap();
            try {
                Properties aLangProps;
                Object aInstanceProps = aModLanguageData.get(aInstance);
                if (aInstanceProps != null && (aLangProps = (Properties)(aProps = (Map)aInstanceProps).get(aLang)) != null) {
                    if (aLangProps.containsKey(aKey)) {
                        aLangProps.remove(aKey);
                        aLangProps.put(aKey, aNewValue);
                    } else {
                        aLangProps.put(aKey, aNewValue);
                    }
                    aProps.remove(aLang);
                    aProps.put(aLang, aLangProps);
                    ReflectionUtils.setField((Object)aInstance, aModLanguageData, aProps);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String getLocalizedNameOfBlock(Block aBlock, int aMeta) {
        if (aBlock != null) {
            return LangUtils.getLocalizedNameOfItemStack(ItemUtils.simpleMetaStack(aBlock, aMeta, 1));
        }
        return "Bad Block Name";
    }

    public static String getLocalizedNameOfItem(Item aItem, int aMeta) {
        if (aItem != null) {
            return LangUtils.getLocalizedNameOfItemStack(ItemUtils.simpleMetaStack(aItem, aMeta, 1));
        }
        return "Bad Item Name";
    }

    public static String getLocalizedNameOfItemStack(ItemStack aStack) {
        if (aStack != null) {
            String aUnlocalized = ItemUtils.getUnlocalizedItemName(aStack) + "." + aStack.func_77960_j() + ".name";
            if (aUnlocalized == null || aUnlocalized.length() <= 0) {
                return "Bad Locale Data";
            }
            String mCacheKey = aUnlocalized;
            if (mLocaleCache.containsKey(mCacheKey)) {
                if (mLocaleCache.get(mCacheKey).toLowerCase().contains(".name") || mLocaleCache.get(mCacheKey).toLowerCase().contains("|")) {
                    String mNew;
                    mLocaleCache.remove(mCacheKey);
                    try {
                        NBTTagCompound nbttagcompound;
                        mNew = ("" + StatCollector.func_74838_a((String)(aStack.func_77973_b().func_77657_g(aStack) + ".name"))).trim();
                        if (aStack.func_77942_o() && aStack.field_77990_d != null && aStack.field_77990_d.func_150297_b("display", 10) && (nbttagcompound = aStack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
                            mNew = nbttagcompound.func_74779_i("Name");
                        }
                    }
                    catch (Throwable t) {
                        mNew = "ERROR - Empty Stack";
                    }
                    Logger.INFO("Re-caching " + mNew + " into locale cache. Key: " + mCacheKey);
                    mLocaleCache.put(mCacheKey, mNew);
                }
                Logger.INFO("Returning Cached Value. Key: " + mCacheKey);
                return mLocaleCache.get(mCacheKey);
            }
            String unlocalizedName = aStack.func_77973_b().func_77667_c(aStack);
            Logger.INFO("Cached New Value. UnlocalName: " + unlocalizedName);
            String blockName = StatCollector.func_74838_a((String)(unlocalizedName + ".name"));
            Logger.INFO("Cached New Value. TranslatedName: " + unlocalizedName);
            if (blockName.toLowerCase().contains(".name") || blockName.toLowerCase().contains("|")) {
                try {
                    NBTTagCompound nbttagcompound;
                    blockName = ("" + StatCollector.func_74838_a((String)(aStack.func_77973_b().func_77657_g(aStack) + ".name"))).trim();
                    if (aStack.func_77942_o() && aStack.field_77990_d != null && aStack.field_77990_d.func_150297_b("display", 10) && (nbttagcompound = aStack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
                        blockName = nbttagcompound.func_74779_i("Name");
                    }
                }
                catch (Throwable t) {
                    blockName = "ERROR - Empty Stack";
                }
            }
            mLocaleCache.put(mCacheKey, blockName);
            Logger.INFO("Cached New Value. Key: " + mCacheKey);
            return blockName;
        }
        return "Bad ItemStack Name";
    }
}

