/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.base.CoreItem;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class ItemGenericToken
extends CoreItem {
    public final HashMap<Integer, String> mLocalNames = new HashMap();
    public final HashMap<Integer, Integer> mMaxStackSizes = new HashMap();
    public final HashMap<Integer, String[]> mDescriptionArrays = new HashMap();
    public final HashMap<Integer, EnumRarity> mRarities = new HashMap();
    public final HashMap<Integer, EnumChatFormatting> mCustomNameColours = new HashMap();
    public final HashMap<Integer, IIcon> mIcons = new HashMap();
    private final String mTextureDir;

    public ItemGenericToken() {
        this("itemGenericToken", "Token", new String[]{"Can be reclaimed in some way, shape or form"}, "token");
    }

    public ItemGenericToken(String aUnlocalName, String aInternalName, String[] aBaseTooltip, String aTextureDir) {
        super(aUnlocalName, aInternalName, AddToCreativeTab.tabMisc, 64, 1000, aBaseTooltip, EnumRarity.common, EnumChatFormatting.RESET, false, null);
        this.mTextureDir = aTextureDir;
        this.func_77625_d(64);
    }

    public boolean register(int id, String aLocalName, int aMaxStack, String aDescript) {
        return this.register(id, aLocalName, aMaxStack, new String[]{aDescript});
    }

    public boolean register(int id, String aLocalName, int aMaxStack, String[] aDescript) {
        return this.register(id, aLocalName, aMaxStack, aDescript, EnumRarity.common, EnumChatFormatting.RESET);
    }

    public boolean register(int id, String aLocalName, int aMaxStack, String[] aDescript, EnumRarity aRarity, EnumChatFormatting aCustomNameColour) {
        int[][] sizes = new int[2][6];
        sizes[0][0] = this.mLocalNames.size();
        sizes[0][1] = this.mMaxStackSizes.size();
        sizes[0][2] = this.mDescriptionArrays.size();
        sizes[0][3] = this.mRarities.size();
        sizes[0][4] = this.mCustomNameColours.size();
        this.mLocalNames.put(id, aLocalName);
        GT_LanguageManager.addStringLocalization((String)("gtplusplus." + this.func_77658_a() + "." + id + ".name"), (String)aLocalName);
        this.mMaxStackSizes.put(id, aMaxStack);
        this.mDescriptionArrays.put(id, aDescript);
        for (int i = 0; i < aDescript.length; ++i) {
            GT_LanguageManager.addStringLocalization((String)("gtplusplus." + this.func_77658_a() + "." + id + ".tooltip." + i), (String)aDescript[i]);
        }
        this.mRarities.put(id, aRarity);
        this.mCustomNameColours.put(id, aCustomNameColour);
        sizes[1][0] = this.mLocalNames.size();
        sizes[1][1] = this.mMaxStackSizes.size();
        sizes[1][2] = this.mDescriptionArrays.size();
        sizes[1][3] = this.mRarities.size();
        sizes[1][4] = this.mCustomNameColours.size();
        boolean b = sizes[0][0] > sizes[1][0] && sizes[0][1] > sizes[1][1] && sizes[0][2] > sizes[1][2] && sizes[0][3] > sizes[1][3] && sizes[0][4] > sizes[1][4];
        return b;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        int j = this.mIcons.size();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            aList.add(tStack);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        super.func_77624_a(stack, aPlayer, list, bool);
        int i = 0;
        while (true) {
            String tooltip = GT_LanguageManager.getTranslation((String)("gtplusplus." + this.func_77657_g(stack) + "." + stack.func_77960_j() + ".tooltip." + i));
            if (("gtplusplus." + this.func_77657_g(stack) + "." + stack.func_77960_j() + ".tooltip." + i).equals(tooltip)) break;
            list.add(tooltip);
            ++i;
        }
    }

    public String func_77653_i(ItemStack tItem) {
        String ret = GT_LanguageManager.getTranslation((String)("gtplusplus." + this.func_77657_g(tItem) + "." + tItem.func_77960_j() + ".name"));
        EnumChatFormatting format = this.mCustomNameColours.get(tItem.func_77960_j());
        if (format != null) {
            ret = format + ret;
        }
        return ret;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return this.mRarities.get(par1ItemStack.func_77960_j());
    }

    @Override
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    public int func_77647_b(int p_77647_1_) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 0.0;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public int getItemStackLimit(ItemStack aStack) {
        if (aStack == null) {
            return this.field_77777_bU;
        }
        Integer aSize = this.mMaxStackSizes.get(aStack.func_77960_j());
        if (aSize != null) {
            return aSize;
        }
        return this.field_77777_bU;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        int j = this.mLocalNames.size();
        for (int i = 0; i < j; ++i) {
            this.mIcons.put(i, aIconRegister.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.mTextureDir + "/" + i));
        }
    }

    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        return this.mIcons.get(aMetaData);
    }
}

