/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.gui.beta;

import gtPlusPlus.core.gui.beta.Gui_Types;
import gtPlusPlus.core.gui.beta.MU_GuiId;
import gtPlusPlus.core.interfaces.IGuiManagerMiscUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Gui_ID_Registry {
    private static final Map<Class<? extends IGuiManagerMiscUtils>, MU_GuiId> classMap = new HashMap<Class<? extends IGuiManagerMiscUtils>, MU_GuiId>();
    private static final Map<Integer, MU_GuiId> idMap = new HashMap<Integer, MU_GuiId>();
    private static int nextId = 0;

    private static void registerGuiHandlers(Gui_Types MU_GuiType, List<Class<? extends IGuiManagerMiscUtils>> guiHandlerClasses) {
        for (Class<? extends IGuiManagerMiscUtils> tileGuiHandlerClass : guiHandlerClasses) {
            MU_GuiId guiId = new MU_GuiId(nextId++, MU_GuiType, tileGuiHandlerClass);
            classMap.put(tileGuiHandlerClass, guiId);
            idMap.put(guiId.getId(), guiId);
        }
    }

    public static MU_GuiId getGuiIdForGuiHandler(IGuiManagerMiscUtils guiHandler) {
        Class<?> guiHandlerClass = guiHandler.getClass();
        MU_GuiId guiId = classMap.get(guiHandlerClass);
        if (guiId == null) {
            for (Map.Entry<Class<? extends IGuiManagerMiscUtils>, MU_GuiId> classGuiIdEntry : classMap.entrySet()) {
                if (!classGuiIdEntry.getKey().isAssignableFrom(guiHandlerClass)) continue;
                guiId = classGuiIdEntry.getValue();
                break;
            }
        }
        if (guiId == null) {
            throw new IllegalStateException("No gui ID for gui handler: " + guiHandler);
        }
        return guiId;
    }

    public static MU_GuiId getGuiId(int id) {
        return idMap.get(id);
    }
}

