/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gtPlusPlus.core.util.Utils;
import java.util.HashMap;
import net.minecraft.util.IIcon;

public class SafeTexture
implements Runnable {
    @SideOnly(value=Side.CLIENT)
    private static final HashMap<Integer, IIcon> mHashToIconCache = new HashMap();
    @SideOnly(value=Side.CLIENT)
    private static final HashMap<String, Integer> mPathToHashCash = new HashMap();
    private static final HashMap<String, SafeTexture> mTextureObjectCache = new HashMap();
    private final int mHash;
    private final String mTextureName;

    private static final String getKey(String aTexPath) {
        String aNameKey = Utils.sanitizeString(aTexPath);
        aNameKey = aNameKey.replace('/', ' ');
        aNameKey = aNameKey.toLowerCase();
        return aNameKey;
    }

    public static SafeTexture register(String aTexturePath) {
        String aNameKey = SafeTexture.getKey(aTexturePath);
        SafeTexture g = mTextureObjectCache.get(aNameKey);
        if (g == null) {
            g = new SafeTexture(aTexturePath);
            mTextureObjectCache.put(aNameKey, g);
            mPathToHashCash.put(aTexturePath, aTexturePath.hashCode());
        }
        return g;
    }

    private SafeTexture(String aTexturePath) {
        this.mTextureName = aTexturePath;
        this.mHash = SafeTexture.getKey(aTexturePath).hashCode();
        GregTech_API.sGTBlockIconload.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return mHashToIconCache.get(this.mHash);
    }

    @Override
    public void run() {
        mHashToIconCache.put(SafeTexture.getKey(this.mTextureName).hashCode(), GregTech_API.sBlockIcons.func_94245_a(this.mTextureName));
    }
}

