/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmableBasic;
import forestry.core.utils.vect.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGenericCrop
implements IFarmableBasic {
    private final ItemStack seed;
    private final Block block;
    private final int mature;
    private final ItemStack[] windfall;

    public FarmableGenericCrop(ItemStack seed, Block block, int mature, ItemStack ... windfall) {
        this.seed = seed;
        this.block = block;
        this.mature = mature;
        this.windfall = windfall;
    }

    @Override
    public boolean isSapling(Block block, int meta) {
        return this.block == block;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this.block) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.mature) {
            return null;
        }
        return new CropBlock(world, this.block, this.mature, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (this.seed.func_77973_b() != itemstack.func_77973_b()) {
            return false;
        }
        if (this.seed.func_77960_j() >= 0) {
            return this.seed.func_77960_j() == itemstack.func_77960_j();
        }
        return true;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, int x, int y, int z) {
        return germling.func_77946_l().func_77943_a(player, world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

