/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.inventory.wrappers.ChestWrapper;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileUtil {
    public static boolean isUsableByPlayer(EntityPlayer player, TileEntity tile) {
        if (tile == null) {
            return false;
        }
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        World world = tile.func_145831_w();
        if (tile.func_145837_r()) {
            return false;
        }
        if (world.func_147438_o(x, y, z) != tile) {
            return false;
        }
        return player.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 64.0;
    }

    public static <T extends TileEntity> T getTile(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileClass.isInstance(tileEntity)) {
            return (T)((TileEntity)tileClass.cast(tileEntity));
        }
        return null;
    }

    public static IInventory getInventoryFromTile(TileEntity tile, ForgeDirection side) {
        if (!(tile instanceof IInventory)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            return new ChestWrapper(chest);
        }
        return InventoryUtil.getInventory((IInventory)tile, side);
    }
}

