/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory.filters;

import forestry.core.inventory.filters.IStackFilter;
import forestry.core.utils.InventoryUtil;
import net.minecraft.item.ItemStack;

public class ArrayStackFilter
implements IStackFilter {
    private final ItemStack[] stacks;

    public ArrayStackFilter(ItemStack ... stacks) {
        this.stacks = stacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (this.stacks.length == 0 || !this.hasFilter()) {
            return true;
        }
        return InventoryUtil.isItemEqual(stack, this.stacks);
    }

    public ItemStack[] getStacks() {
        return this.stacks;
    }

    private boolean hasFilter() {
        for (ItemStack filter : this.stacks) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }
}

