/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world.claims;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ftb.lib.BlockDimPos;
import ftb.lib.FTBLib;
import ftb.lib.LMDimUtils;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.item.LMInvUtils;
import ftb.utils.mod.config.FTBUConfigGeneral;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorld;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.ChunkType;
import ftb.utils.world.claims.ClaimedChunk;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import latmod.lib.Bits;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMMapUtils;
import latmod.lib.LMUtils;
import latmod.lib.MathHelperLM;
import latmod.lib.util.EnumEnabled;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class ClaimedChunks {
    public final Map<Integer, Map<Long, ClaimedChunk>> chunks = new HashMap<Integer, Map<Long, ClaimedChunk>>();

    public List<ClaimedChunk> getAllChunks() {
        ArrayList<ClaimedChunk> l = new ArrayList<ClaimedChunk>();
        for (Map<Long, ClaimedChunk> m : this.chunks.values()) {
            l.addAll(m.values());
        }
        return l;
    }

    public void load(NBTTagCompound tag) {
        this.chunks.clear();
        Map tag1 = LMNBTUtils.toMapWithType((NBTTagCompound)tag.func_74775_l("ClaimedChunks"));
        for (Map.Entry e : tag1.entrySet()) {
            try {
                int dim = Integer.parseInt((String)e.getKey());
                HashMap<Long, ClaimedChunk> map = new HashMap<Long, ClaimedChunk>();
                Map tag2 = LMNBTUtils.toMapWithType((NBTTagCompound)((NBTTagCompound)e.getValue()));
                for (Map.Entry e1 : tag2.entrySet()) {
                    NBTTagList chunksList = (NBTTagList)e1.getValue();
                    for (int k = 0; k < chunksList.func_74745_c(); ++k) {
                        int[] ai = chunksList.func_150306_c(k);
                        ClaimedChunk c = new ClaimedChunk(Integer.parseInt((String)e1.getKey()), dim, ai[0], ai[1]);
                        if (ai.length >= 3 && ai[2] == 1) {
                            c.isChunkloaded = true;
                        }
                        map.put(Bits.intsToLong((int)ai[0], (int)ai[1]), c);
                    }
                }
                this.chunks.put(dim, map);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void load(JsonObject group) {
        for (Map.Entry e : group.entrySet()) {
            int dim = Integer.parseInt((String)e.getKey());
            HashMap<Long, ClaimedChunk> map = new HashMap<Long, ClaimedChunk>();
            for (Map.Entry e1 : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                try {
                    LMPlayerServer p = LMWorldServer.inst.getPlayer(LMUtils.fromString((String)((String)e1.getKey())));
                    if (p == null) continue;
                    JsonArray chunksList = ((JsonElement)e1.getValue()).getAsJsonArray();
                    for (int k = 0; k < chunksList.size(); ++k) {
                        int[] ai = LMJsonUtils.fromIntArray((JsonElement)chunksList.get(k));
                        if (ai == null) continue;
                        ClaimedChunk c = new ClaimedChunk(p.getPlayerID(), dim, ai[0], ai[1]);
                        if (ai.length >= 3 && ai[2] == 1) {
                            c.isChunkloaded = true;
                        }
                        map.put(Bits.intsToLong((int)ai[0], (int)ai[1]), c);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.chunks.put(dim, map);
        }
    }

    public void save(JsonObject group) {
        Comparator comparator = LMMapUtils.byKeyNumbers();
        Comparator comparator2 = LMMapUtils.byKeyNumbers();
        for (Map.Entry e : LMMapUtils.sortedEntryList(this.chunks, (Comparator)comparator)) {
            JsonObject o1 = new JsonObject();
            for (ClaimedChunk c : LMMapUtils.values((Map)((Map)e.getValue()), (Comparator)comparator2)) {
                LMPlayerServer p = c.getOwnerS();
                if (p == null) continue;
                String id = p.getStringUUID();
                if (!o1.has(id)) {
                    o1.add(id, (JsonElement)new JsonArray());
                }
                JsonArray a = o1.get(id).getAsJsonArray();
                JsonArray a1 = new JsonArray();
                a1.add((JsonElement)new JsonPrimitive((Number)c.posX));
                a1.add((JsonElement)new JsonPrimitive((Number)c.posZ));
                if (c.isChunkloaded) {
                    a1.add((JsonElement)new JsonPrimitive((Number)1));
                }
                a.add((JsonElement)a1);
            }
            group.add(((Integer)e.getKey()).toString(), (JsonElement)o1);
        }
    }

    public ClaimedChunk getChunk(int dim, int cx, int cz) {
        if (!this.chunks.containsKey(dim)) {
            return null;
        }
        return this.chunks.get(dim).get(Bits.intsToLong((int)cx, (int)cz));
    }

    public List<ClaimedChunk> getChunks(LMPlayerServer p, Integer dim) {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        if (p == null || p.isFake()) {
            return list;
        }
        if (dim == null) {
            for (Map<Long, ClaimedChunk> map : this.chunks.values()) {
                for (ClaimedChunk c : map.values()) {
                    if (c == null || c.ownerID != p.getPlayerID()) continue;
                    list.add(c);
                }
            }
        } else {
            Map<Long, ClaimedChunk> map = this.chunks.get(dim);
            if (map == null) {
                return list;
            }
            for (ClaimedChunk c : map.values()) {
                if (c == null || c.ownerID != p.getPlayerID()) continue;
                list.add(c);
            }
        }
        return list;
    }

    public boolean put(ClaimedChunk c) {
        if (c == null) {
            return false;
        }
        Map<Long, ClaimedChunk> map = this.chunks.get(c.dim);
        if (map == null) {
            map = new HashMap<Long, ClaimedChunk>();
            this.chunks.put(c.dim, map);
        }
        return map.put(c.getLongPos(), c) == null;
    }

    public ClaimedChunk remove(int dim, int cx, int cz) {
        ClaimedChunk chunk;
        Map<Long, ClaimedChunk> map = this.chunks.get(dim);
        if (map != null && (chunk = map.remove(Bits.intsToLong((int)cx, (int)cz))) != null) {
            if (map.isEmpty()) {
                this.chunks.remove(dim);
            }
            return chunk;
        }
        return null;
    }

    public ChunkType getType(int dim, int cx, int cz) {
        World w = LMDimUtils.getWorld((int)dim);
        if (w == null || !w.func_72863_F().func_73149_a(cx, cz)) {
            return ChunkType.UNLOADED;
        }
        if (ClaimedChunks.isInSpawn(dim, cx, cz)) {
            return ChunkType.SPAWN;
        }
        if (LMWorldServer.inst.settings.getWB(dim).isOutside(cx, cz)) {
            return ChunkType.WORLD_BORDER;
        }
        ClaimedChunk c = this.getChunk(dim, cx, cz);
        if (c == null) {
            return ChunkType.WILDERNESS;
        }
        return new ChunkType.PlayerClaimed(LMWorldServer.inst.getPlayer(c.ownerID));
    }

    public ChunkType getTypeD(int dim, ChunkCoordinates pos) {
        return this.getType(dim, MathHelperLM.chunk((int)pos.field_71574_a), MathHelperLM.chunk((int)pos.field_71573_c));
    }

    public static ChunkType getChunkTypeFromI(int i) {
        if (i <= 0) {
            return ChunkType.UNCLAIMED_VALUES[-i];
        }
        LMPlayer p = LMWorld.getWorld().getPlayer(i);
        return p == null ? ChunkType.WILDERNESS : new ChunkType.PlayerClaimed(p);
    }

    public static boolean isInSpawn(int dim, int cx, int cz) {
        if (dim != 0 || !FTBLib.isDedicatedServer() && !FTBUConfigGeneral.spawn_area_in_sp.getAsBoolean()) {
            return false;
        }
        int radius = FTBLib.getServer().func_82357_ak();
        if (radius <= 0) {
            return false;
        }
        BlockDimPos c = LMDimUtils.getSpawnPoint((int)0);
        int minX = MathHelperLM.chunk((double)((double)c.x + 0.5 - (double)radius));
        int minZ = MathHelperLM.chunk((double)((double)c.z + 0.5 - (double)radius));
        int maxX = MathHelperLM.chunk((double)((double)c.x + 0.5 + (double)radius));
        int maxZ = MathHelperLM.chunk((double)((double)c.z + 0.5 + (double)radius));
        return cx >= minX && cx <= maxX && cz >= minZ && cz <= maxZ;
    }

    public static boolean isInSpawnD(int dim, double x, double z) {
        return dim == 0 && ClaimedChunks.isInSpawn(dim, MathHelperLM.chunk((double)x), MathHelperLM.chunk((double)z));
    }

    public boolean allowExplosion(int dim, int cx, int cz) {
        LMPlayerServer p;
        if (dim == 0 && FTBUConfigGeneral.safe_spawn.getAsBoolean() && ClaimedChunks.isInSpawn(dim, cx, cz)) {
            return false;
        }
        if (LMWorldServer.inst.settings.getWB(dim).isOutside(cx, cz)) {
            return false;
        }
        ClaimedChunk c = this.getChunk(dim, cx, cz);
        if (c != null && (p = c.getOwnerS()) != null) {
            EnumEnabled fe = (EnumEnabled)p.getRank().config.forced_explosions.get();
            if (fe == null) {
                return p.getSettings().get((byte)1);
            }
            return fe.isEnabled();
        }
        return true;
    }

    public static boolean canPlayerInteract(EntityPlayer ep, ChunkCoordinates pos, boolean leftClick) {
        if (ep == null || ep.field_70170_p == null || ep.field_70170_p.field_72995_K) {
            return true;
        }
        LMPlayerServer p = LMWorldServer.inst.getPlayer(ep);
        if (p == null) {
            return true;
        }
        if (!p.isFake() && p.allowInteractSecure()) {
            return true;
        }
        if (LMWorldServer.inst.settings.getWB(ep.field_71093_bK).isOutsideD(pos.field_71574_a, pos.field_71573_c)) {
            return false;
        }
        if (leftClick && p.getRank().config.break_whitelist.getAsStringList().contains(LMInvUtils.getRegName((Block)ep.field_70170_p.func_147439_a(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c)))) {
            return true;
        }
        ChunkType type = LMWorldServer.inst.claimedChunks.getTypeD(ep.field_71093_bK, pos);
        return type.canInteract(p, leftClick);
    }
}

