/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.FTBLib;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.client.FTBLibClient;
import ftb.utils.api.EventLMPlayerClient;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerClient;
import ftb.utils.world.LMPlayerClientSelf;
import ftb.utils.world.LMWorld;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class LMWorldClient
extends LMWorld {
    public static LMWorldClient inst = null;
    public final int clientPlayerID;
    public final Map<Integer, LMPlayerClient> playerMap;
    public LMPlayerClientSelf clientPlayer = null;

    public LMWorldClient(int i) {
        super(Side.CLIENT);
        this.clientPlayerID = i;
        this.playerMap = new HashMap<Integer, LMPlayerClient>();
    }

    @Override
    public Map<Integer, ? extends LMPlayer> playerMap() {
        return this.playerMap;
    }

    @Override
    public World getMCWorld() {
        return FTBLibClient.mc.field_71441_e;
    }

    @Override
    public LMWorldClient getClientWorld() {
        return this;
    }

    @Override
    public LMPlayerClient getPlayer(Object o) {
        LMPlayer p = super.getPlayer(o);
        return p == null ? null : p.toPlayerSP();
    }

    public void readDataFromNet(ByteIOStream io, boolean first) {
        if (first) {
            this.playerMap.clear();
            GameProfile gp = FTBLibClient.mc.func_110432_I().func_148256_e();
            this.clientPlayer = new LMPlayerClientSelf(this, this.clientPlayerID, gp);
            int psize = io.readInt();
            for (int i = 0; i < psize; ++i) {
                int id = io.readInt();
                UUID uuid = io.readUUID();
                String name = io.readUTF();
                if (id == this.clientPlayerID) {
                    this.playerMap.put(id, this.clientPlayer);
                    continue;
                }
                this.playerMap.put(id, new LMPlayerClient(this, id, new GameProfile(uuid, name)));
            }
            FTBLib.dev_logger.info("Client player ID: " + this.clientPlayerID);
            int[] onlinePlayers = io.readIntArray(ByteCount.INT);
            for (int i = 0; i < onlinePlayers.length; ++i) {
                LMPlayerClient p;
                p.readFromNet(io, (p = this.playerMap.get(onlinePlayers[i]).toPlayerSP()).getPlayerID() == this.clientPlayerID);
                new EventLMPlayerClient.DataLoaded(p).post();
            }
            this.clientPlayer.readFromNet(io, true);
            new EventLMPlayerClient.DataLoaded(this.clientPlayer).post();
        }
        this.customCommonData.readFromNBT(LMNBTUtils.readTag((ByteIOStream)io), false);
        this.settings.readFromNet(io);
    }
}

