/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.handlers.ftbl;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.EventFTBReload;
import ftb.lib.api.EventFTBWorldClient;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.client.LMFrustrumUtils;
import ftb.lib.api.client.model.CubeRenderer;
import ftb.lib.api.notification.ClientNotifications;
import ftb.lib.mod.FTBLibMod;
import ftb.utils.api.EventLMWorldClient;
import ftb.utils.api.guide.ClientGuideFile;
import ftb.utils.badges.ClientBadges;
import ftb.utils.mod.client.gui.claims.ClaimedAreasClient;
import ftb.utils.mod.handlers.ftbl.FTBLIntegration;
import ftb.utils.world.LMWorldClient;
import ftb.utils.world.claims.WorldBorder;
import latmod.lib.ByteIOStream;
import latmod.lib.MathHelperLM;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FTBLIntegrationClient
extends FTBLIntegration {
    public static final ResourceLocation world_border_tex = new ResourceLocation("ftbu", "textures/map/world_border.png");
    private static final CubeRenderer worldBorderRenderer = new CubeRenderer();

    @Override
    public void onReloaded(EventFTBReload e) {
        super.onReloaded(e);
        if (e.world.side.isClient()) {
            FTBLibClient.clearCachedData();
            ClientBadges.clearPlayerBadges();
            ClientGuideFile.instance.reload(e);
        }
    }

    @Override
    public void onFTBWorldClient(EventFTBWorldClient e) {
        ClientNotifications.init();
        ClaimedAreasClient.clear();
        if (e.world == null) {
            if (LMWorldClient.inst != null) {
                new EventLMWorldClient(LMWorldClient.inst, true).post();
            }
            LMWorldClient.inst = null;
        }
    }

    @Override
    public void readWorldData(ByteIOStream io) {
        LMWorldClient.inst = new LMWorldClient(io.readInt());
        LMWorldClient.inst.readDataFromNet(io, true);
        FTBLibMod.logger.info("Joined the server with PlayerID " + LMWorldClient.inst.clientPlayerID);
        new EventLMWorldClient(LMWorldClient.inst, false).post();
    }

    @Override
    public boolean hasClientWorld() {
        return LMWorldClient.inst != null && LMWorldClient.inst.clientPlayerID > 0 && LMWorldClient.inst.clientPlayer != null;
    }

    @Override
    public void renderWorld(float pt) {
        if (!FTBLibClient.isIngameWithFTBU() || !LMWorldClient.inst.settings.border_enabled.getAsBoolean()) {
            return;
        }
        WorldBorder wb = LMWorldClient.inst.settings.getWB(FTBLibClient.getDim());
        int s = wb.getSize();
        if (s <= 0) {
            return;
        }
        double minX = ((double)MathHelperLM.chunk((int)(-s + wb.pos.x)) + 1.0) * 16.0 + 0.01;
        double maxX = (double)MathHelperLM.chunk((int)(s + wb.pos.x)) * 16.0 - 0.01;
        double minZ = ((double)MathHelperLM.chunk((int)(-s + wb.pos.y)) + 1.0) * 16.0 + 0.01;
        double maxZ = (double)MathHelperLM.chunk((int)(s + wb.pos.y)) * 16.0 - 0.01;
        double rd = 32.0;
        boolean renderWest = LMFrustrumUtils.playerX <= minX + rd;
        boolean renderEast = LMFrustrumUtils.playerX >= maxX - rd;
        boolean renderNorth = LMFrustrumUtils.playerZ <= minZ + rd;
        boolean renderSouth = LMFrustrumUtils.playerZ >= maxZ - rd;
        GlStateManager.pushAttrib();
        GlStateManager.enableBlend();
        GlStateManager.disableLighting();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.disableCull();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableTexture2D();
        FTBLibClient.pushMaxBrightness();
        FTBLibClient.setTexture((ResourceLocation)world_border_tex);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)(-LMFrustrumUtils.renderX), (double)(-LMFrustrumUtils.renderY), (double)(-LMFrustrumUtils.renderZ));
        double f = (double)Minecraft.func_71386_F() * 5.0E-4 % 1.0;
        worldBorderRenderer.setTessellator(Tessellator.field_78398_a);
        worldBorderRenderer.setSize(minX, 0.0, minZ, maxX, 256.0, maxZ);
        worldBorderRenderer.setUV(minX + f, 0.0, maxX + f, 256.0);
        float maxA = 0.6f;
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)maxA);
        if (renderWest) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(maxA - (float)((LMFrustrumUtils.playerX - minX) * (double)maxA / rd)));
            worldBorderRenderer.renderWest();
        }
        if (renderEast) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(maxA - (float)((maxX - LMFrustrumUtils.playerX) * (double)maxA / rd)));
            worldBorderRenderer.renderEast();
        }
        if (renderNorth) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(maxA - (float)((LMFrustrumUtils.playerZ - minZ) * (double)maxA / rd)));
            worldBorderRenderer.renderNorth();
        }
        if (renderSouth) {
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)(maxA - (float)((maxZ - LMFrustrumUtils.playerZ) * (double)maxA / rd)));
            worldBorderRenderer.renderSouth();
        }
        GlStateManager.popMatrix();
        GlStateManager.shadeModel((int)7424);
        FTBLibClient.popMaxBrightness();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.popAttrib();
    }

    @Override
    public void onTooltip(ItemTooltipEvent e) {
    }
}

