/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ftb.lib.LMNBTUtils;
import ftb.utils.api.EventLMWorldServer;
import ftb.utils.mod.FTBU;
import ftb.utils.mod.config.FTBUConfigGeneral;
import ftb.utils.mod.handlers.FTBUChunkEventHandler;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.ClaimedChunks;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import latmod.lib.LMFileUtils;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMStringUtils;
import latmod.lib.MathHelperLM;
import latmod.lib.util.Phase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;

public class FTBUWorldEventHandler {
    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load e) {
        if (e.world instanceof WorldServer) {
            FTBUChunkEventHandler.instance.markDirty(e.world);
        }
        try {
            Path worldPath = e.world.func_72860_G().func_75765_b().toPath();
            Path oldFile = worldPath.resolve("latmod").resolve("LMPlayers.txt");
            Path newFile = worldPath.resolve("LatMod").resolve("LMPlayers.txt");
            if (oldFile.toFile().exists() && !newFile.toFile().exists()) {
                FTBU.logger.info("Attempting to move " + oldFile + " to " + newFile);
                Files.move(oldFile, newFile, new CopyOption[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void worldSaved(WorldEvent.Save e) {
        if (e.world.field_73011_w.field_76574_g == 0 && e.world instanceof WorldServer) {
            new EventLMWorldServer.Saved(LMWorldServer.inst).post();
            JsonObject group = new JsonObject();
            LMWorldServer.inst.save(group, Phase.PRE);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound players = new NBTTagCompound();
            LMWorldServer.inst.writePlayersToServer(players);
            tag.func_74782_a("Players", (NBTBase)players);
            tag.func_74768_a("LastID", LMPlayerServer.lastPlayerID);
            LMNBTUtils.writeMap((File)new File(LMWorldServer.inst.latmodFolder, "LMPlayers.dat"), (NBTTagCompound)tag);
            LMWorldServer.inst.save(group, Phase.POST);
            LMJsonUtils.toJson((File)new File(LMWorldServer.inst.latmodFolder, "LMWorld.json"), (JsonElement)group);
            group = new JsonObject();
            LMWorldServer.inst.claimedChunks.save(group);
            LMJsonUtils.toJson((File)new File(LMWorldServer.inst.latmodFolder, "ClaimedChunks.json"), (JsonElement)group);
            try {
                ArrayList<String> l = new ArrayList<String>();
                int[] list = LMWorldServer.inst.getAllPlayerIDs();
                Arrays.sort(list);
                for (int i = 0; i < list.length; ++i) {
                    LMPlayerServer p = LMWorldServer.inst.getPlayer(list[i]);
                    StringBuilder sb = new StringBuilder();
                    sb.append(LMStringUtils.fillString((String)Integer.toString(p.getPlayerID()), (char)' ', (int)6));
                    sb.append(LMStringUtils.fillString((String)p.getProfile().getName(), (char)' ', (int)21));
                    sb.append(p.getStringUUID());
                    l.add(sb.toString());
                }
                LMFileUtils.save((File)new File(LMWorldServer.inst.latmodFolder, "LMPlayers.txt"), l);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onMobSpawned(EntityJoinWorldEvent e) {
        if (!e.world.field_72995_K && !this.isEntityAllowed(e.entity)) {
            e.entity.func_70106_y();
            e.setCanceled(true);
        }
    }

    private boolean isEntityAllowed(Entity e) {
        if (e instanceof EntityPlayer) {
            return true;
        }
        if (FTBUConfigGeneral.isEntityBanned(e.getClass())) {
            return false;
        }
        if (FTBUConfigGeneral.safe_spawn.getAsBoolean() && ClaimedChunks.isInSpawnD(e.field_71093_bK, e.field_70165_t, e.field_70161_v)) {
            if (e instanceof IMob) {
                return false;
            }
            if (e instanceof EntityChicken && e.field_70153_n != null) {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start e) {
        int cz;
        if (e.world.field_72995_K) {
            return;
        }
        int dim = e.world.field_73011_w.field_76574_g;
        int cx = MathHelperLM.chunk((double)e.explosion.field_77284_b);
        if (!LMWorldServer.inst.claimedChunks.allowExplosion(dim, cx, cz = MathHelperLM.chunk((double)e.explosion.field_77282_d))) {
            e.setCanceled(true);
        }
    }
}

