/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.cmd.admin;

import ftb.lib.api.cmd.CommandLM;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.cmd.CommandSubLM;
import ftb.utils.world.LMWorldServer;
import latmod.lib.MathHelperLM;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CmdWorldBorder
extends CommandSubLM {
    public CmdWorldBorder() {
        super("world_border", CommandLevel.OP);
        this.add(new CmdOn("on"));
        this.add(new CmdOff("off"));
        this.add(new CmdSet("set"));
        this.add(new CmdGet("get"));
        this.add(new CmdCenter("center"));
    }

    private static class CmdCenter
    extends CommandLM {
        public CmdCenter(String s) {
            super(s, CommandLevel.OP);
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            int dim;
            int z;
            int x;
            if (args.length >= 2) {
                x = CmdCenter.func_71526_a((ICommandSender)ics, (String)args[0]);
                z = CmdCenter.func_71526_a((ICommandSender)ics, (String)args[1]);
                dim = args.length >= 3 ? CmdCenter.func_71526_a((ICommandSender)ics, (String)args[2]) : ics.func_130014_f_().field_73011_w.field_76574_g;
            } else {
                EntityPlayerMP ep = CmdCenter.func_71521_c((ICommandSender)ics);
                x = MathHelperLM.floor((double)ep.field_70165_t);
                z = MathHelperLM.floor((double)ep.field_70161_v);
                dim = ep.field_71093_bK;
            }
            LMWorldServer.inst.settings.getAndSet(dim).setPos(x, z);
            LMWorldServer.inst.update(LMWorldServer.inst.getPlayer(ics));
            return new ChatComponentText("World center for dimension " + dim + " set to " + x + " : " + z);
        }
    }

    private static class CmdGet
    extends CommandLM {
        public CmdGet(String s) {
            super(s, CommandLevel.OP);
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdGet.checkArgs((String[])args, (int)1);
            int dim = CmdGet.func_71526_a((ICommandSender)ics, (String)args[0]);
            return new ChatComponentText("World border for dimension " + dim + ": " + LMWorldServer.inst.settings.getWB(dim).getSize());
        }
    }

    private static class CmdSet
    extends CommandLM {
        public CmdSet(String s) {
            super(s, CommandLevel.OP);
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            CmdSet.checkArgs((String[])args, (int)2);
            int dim = CmdSet.func_71526_a((ICommandSender)ics, (String)args[0]);
            int dist = CmdSet.func_71526_a((ICommandSender)ics, (String)args[1]);
            LMWorldServer.inst.settings.getAndSet(dim).setSize(dist);
            return new ChatComponentText("World border for dimension " + dim + " set to " + dist);
        }
    }

    private static class CmdOff
    extends CommandLM {
        public CmdOff(String s) {
            super(s, CommandLevel.OP);
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            LMWorldServer.inst.settings.border_enabled.set(false);
            LMWorldServer.inst.update(LMWorldServer.inst.getPlayer(ics));
            return new ChatComponentText("World border disabled");
        }
    }

    private static class CmdOn
    extends CommandLM {
        public CmdOn(String s) {
            super(s, CommandLevel.OP);
        }

        public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
            LMWorldServer.inst.settings.border_enabled.set(true);
            LMWorldServer.inst.update(LMWorldServer.inst.getPlayer(ics));
            return new ChatComponentText("World border enabled");
        }
    }
}

