/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.net;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import latmod.lib.ByteIOStream;
import latmod.lib.LMUtils;
import latmod.lib.net.RequestMethod;
import latmod.lib.net.Response;

public class LMURLConnection {
    public final RequestMethod type;
    public final String url;
    public final ByteIOStream data;

    public LMURLConnection(RequestMethod t, String s) {
        this.type = t;
        this.url = s;
        this.data = new ByteIOStream();
    }

    public Response connect() throws Exception {
        long startTime = LMUtils.millis();
        if (this.type == null || this.type == RequestMethod.SIMPLE_GET) {
            URL con = new URL(this.url);
            InputStream is = con.openStream();
            return new Response(LMUtils.millis() - startTime, 200, is);
        }
        if (this.type == RequestMethod.FILE) {
            FileInputStream is = new FileInputStream(this.url);
            return new Response(LMUtils.millis() - startTime, 200, is);
        }
        HttpURLConnection con = (HttpURLConnection)new URL(this.url).openConnection();
        con.setRequestMethod(this.type.name());
        con.setRequestProperty("User-Agent", "HTTP/1.1");
        con.setDoInput(true);
        if (this.data.getDataPos() > 0) {
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(this.data.toByteArray());
            os.flush();
            os.close();
        }
        int responseCode = con.getResponseCode();
        return new Response(LMUtils.millis() - startTime, responseCode, con.getInputStream());
    }
}

