/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import latmod.lib.ByteIOStream;

public class JsonElementIO {
    public static JsonID getID(JsonElement e) {
        if (e == null || e.isJsonNull()) {
            return JsonID.NULL;
        }
        if (e.isJsonArray()) {
            return JsonID.ARRAY;
        }
        if (e.isJsonObject()) {
            return JsonID.OBJECT;
        }
        JsonPrimitive p = e.getAsJsonPrimitive();
        if (p.isString()) {
            return JsonID.STRING;
        }
        if (p.isBoolean()) {
            return JsonID.BOOL;
        }
        Number n = p.getAsNumber();
        System.out.println(n.getClass());
        if (n instanceof Integer) {
            return JsonID.INT;
        }
        if (n instanceof Byte) {
            return JsonID.BYTE;
        }
        if (n instanceof Short) {
            return JsonID.SHORT;
        }
        if (n instanceof Long) {
            return JsonID.LONG;
        }
        if (n instanceof Float) {
            return JsonID.FLOAT;
        }
        if (n instanceof Double) {
            return JsonID.DOUBLE;
        }
        return JsonID.NULL;
    }

    public static JsonElement read(ByteIOStream io) {
        switch (JsonID.values()[io.readByte()]) {
            case NULL: {
                return JsonNull.INSTANCE;
            }
            case ARRAY: {
                JsonArray a = new JsonArray();
                int s = io.readInt();
                for (int i = 0; i < s; ++i) {
                    a.add(JsonElementIO.read(io));
                }
                return a;
            }
            case OBJECT: {
                JsonObject o = new JsonObject();
                int s = io.readInt();
                for (int i = 0; i < s; ++i) {
                    String key = io.readUTF();
                    o.add(key, JsonElementIO.read(io));
                }
                return o;
            }
            case STRING: {
                return new JsonPrimitive(io.readUTF());
            }
            case BOOL: {
                return new JsonPrimitive(Boolean.valueOf(io.readBoolean()));
            }
            case BYTE: {
                return new JsonPrimitive((Number)io.readByte());
            }
            case SHORT: {
                return new JsonPrimitive((Number)io.readShort());
            }
            case INT: {
                return new JsonPrimitive((Number)io.readInt());
            }
            case LONG: {
                return new JsonPrimitive((Number)io.readLong());
            }
            case FLOAT: {
                return new JsonPrimitive((Number)Float.valueOf(io.readFloat()));
            }
            case DOUBLE: {
                return new JsonPrimitive((Number)io.readDouble());
            }
        }
        return JsonNull.INSTANCE;
    }

    public static void write(ByteIOStream io, JsonElement e) {
        if (e == null || e.isJsonNull()) {
            io.writeByte(JsonID.NULL.ID);
        } else if (e.isJsonArray()) {
            io.writeByte(JsonID.ARRAY.ID);
            JsonArray a = e.getAsJsonArray();
            int s = a.size();
            io.writeInt(s);
            for (int i = 0; i < s; ++i) {
                JsonElementIO.write(io, a.get(i));
            }
        } else if (e.isJsonObject()) {
            io.writeByte(JsonID.OBJECT.ID);
            Set set = e.getAsJsonObject().entrySet();
            io.writeInt(set.size());
            for (Map.Entry entry : set) {
                io.writeUTF((String)entry.getKey());
                JsonElementIO.write(io, (JsonElement)entry.getValue());
            }
        } else {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                io.writeByte(JsonID.STRING.ID);
                io.writeUTF(p.getAsString());
            } else if (p.isBoolean()) {
                io.writeByte(JsonID.BOOL.ID);
                io.writeBoolean(p.getAsBoolean());
            } else {
                Number n = p.getAsNumber();
                System.out.println(n.getClass());
                if (n instanceof Integer) {
                    io.writeByte(JsonID.INT.ID);
                    io.writeInt(n.intValue());
                } else if (n instanceof Byte) {
                    io.writeByte(JsonID.BYTE.ID);
                    io.writeByte(n.byteValue());
                } else if (n instanceof Short) {
                    io.writeByte(JsonID.SHORT.ID);
                    io.writeShort(n.shortValue());
                } else if (n instanceof Long) {
                    io.writeByte(JsonID.LONG.ID);
                    io.writeLong(n.longValue());
                } else if (n instanceof Float) {
                    io.writeByte(JsonID.FLOAT.ID);
                    io.writeFloat(n.floatValue());
                } else if (n instanceof Double) {
                    io.writeByte(JsonID.DOUBLE.ID);
                    io.writeDouble(n.doubleValue());
                } else {
                    io.writeByte(JsonID.NULL.ID);
                }
            }
        }
    }

    public static enum JsonID {
        NULL,
        ARRAY,
        OBJECT,
        STRING,
        BOOL,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE;

        public final byte ID = (byte)this.ordinal();
        public final String name = this.name().toLowerCase();
    }
}

