/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import latmod.lib.github.GitHubCommit;
import latmod.lib.util.FinalIDObject;

public abstract class GitHubFile
extends FinalIDObject {
    public final GitHubCommit commit;
    public final GitHubFile parent;
    public final String url;
    public final String path;

    public GitHubFile(GitHubCommit p, GitHubFile pt, JsonObject o) throws Exception {
        super(o.get("sha").getAsString());
        this.commit = p;
        this.parent = pt;
        this.url = o.get("url").getAsString();
        this.path = o.get("path").getAsString();
    }

    public String getPath() {
        return this.parent == null ? this.path : this.parent.getPath() + "/" + this.path;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    public static GitHubFile getFrom(GitHubCommit commit, GitHubFile parent, JsonObject o) throws Exception {
        if (o.get("type").getAsString().equals("tree")) {
            return new Tree(commit, parent, o);
        }
        return new Blob(commit, parent, o);
    }

    public static class Tree
    extends GitHubFile {
        public final List<JsonObject> tree;

        public Tree(GitHubCommit p, GitHubFile pt, JsonObject o) throws Exception {
            super(p, pt, o);
            ArrayList l = new ArrayList();
            if (o.has("tree")) {
                JsonArray a = o.get("tree").getAsJsonArray();
                for (JsonElement jsonElement : a) {
                }
            }
            this.tree = Collections.unmodifiableList(l);
        }
    }

    public static class Blob
    extends GitHubFile {
        public final String pathURL;
        public final int size;
        public final String encoding;

        public Blob(GitHubCommit p, GitHubFile pt, JsonObject o) throws Exception {
            super(p, pt, o);
            this.pathURL = this.commit.getFilePath(this.getPath()).replace(" ", "%20");
            this.size = o.get("size").getAsInt();
            this.encoding = o.has("encoding") ? o.get("encoding").getAsString() : "";
        }
    }
}

