/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import latmod.lib.LMColorUtils;
import latmod.lib.LMUtils;

public class PixelBuffer {
    public final int width;
    public final int height;
    public final int[] pixels;

    public PixelBuffer(int w, int h) {
        this.width = w;
        this.height = h;
        this.pixels = new int[w * h];
    }

    public PixelBuffer(BufferedImage img) {
        this(img.getWidth(), img.getHeight());
        img.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    public void setPixels(int[] rgbArray) {
        if (rgbArray.length == this.pixels.length) {
            System.arraycopy(rgbArray, 0, this.pixels, 0, this.pixels.length);
        }
    }

    public void setRGB(int x, int y, int col) {
        this.pixels[x + y * this.width] = col;
    }

    public int getRGB(int x, int y) {
        return this.pixels[x + y * this.width];
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray) {
        int off = -1;
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                this.setRGB(x, y, rgbArray[++off]);
            }
        }
    }

    public void setRGB(int startX, int startY, PixelBuffer buffer) {
        this.setRGB(startX, startY, buffer.width, buffer.height, buffer.pixels);
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray) {
        if (rgbArray == null || rgbArray.length != w * h) {
            rgbArray = new int[w * h];
        }
        int off = -1;
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                rgbArray[++off] = this.getRGB(x, y);
            }
        }
        return rgbArray;
    }

    public BufferedImage toImage(int type) {
        BufferedImage image = new BufferedImage(this.width, this.height, type);
        image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        return image;
    }

    public void fill(int col) {
        Arrays.fill(this.pixels, col);
    }

    public void fill(int startX, int startY, int w, int h, int col) {
        for (int y = startY; y < startY + h; ++y) {
            for (int x = startX; x < startX + w; ++x) {
                this.setRGB(x, y, col);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PixelBuffer) {
            PixelBuffer b = (PixelBuffer)o;
            if (this.width == b.width && this.height == b.height) {
                for (int i = 0; i < this.pixels.length; ++i) {
                    if (this.pixels[i] == b.pixels[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return LMUtils.hashCode(this.width, this.height, this.pixels);
    }

    public PixelBuffer copy() {
        PixelBuffer b = new PixelBuffer(this.width, this.height);
        System.arraycopy(this.pixels, 0, b.pixels, 0, this.pixels.length);
        return b;
    }

    public PixelBuffer getSubimage(int x, int y, int w, int h) {
        PixelBuffer b = new PixelBuffer(w, h);
        this.getRGB(x, y, w, h, b.pixels);
        return b;
    }

    public void addHSB(float h, float s, float b) {
        LMColorUtils.addHSB(this.pixels, h, s, b);
    }
}

