/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.net;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import ftb.lib.FTBLib;
import ftb.lib.FTBWorld;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.EventFTBReload;
import ftb.lib.api.GameModes;
import ftb.lib.api.config.ConfigGroup;
import ftb.lib.api.config.ConfigRegistry;
import ftb.lib.api.net.LMNetworkWrapper;
import ftb.lib.api.net.MessageLM;
import ftb.lib.api.notification.ClientNotifications;
import ftb.lib.api.notification.Notification;
import ftb.lib.mod.FTBLibMod;
import ftb.lib.mod.client.FTBLibModClient;
import ftb.lib.mod.net.FTBLibNetHandler;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import latmod.lib.LMUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;

public class MessageReload
extends MessageLM {
    public MessageReload() {
        super(ByteCount.INT);
    }

    public MessageReload(FTBWorld w, int reloadClient) {
        this();
        this.io.writeByte(reloadClient);
        if (reloadClient > 0) {
            w.writeReloadData(this.io);
            MessageReload.writeSyncedConfig(this.io);
        }
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public IMessage onMessage(MessageContext ctx) {
        byte reload;
        if (FTBLib.DEV_ENV) {
            FTBLib.dev_logger.info("--------< RELOADING >----------");
        }
        if ((reload = this.io.readByte()) == 0) {
            Notification n = new Notification("reload_client_config", FTBLibMod.mod.chatComponent("reload_client_config", new Object[0]), 7000);
            n.title.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
            n.desc = new ChatComponentText("/" + FTBLibModClient.reload_client_cmd.getAsString());
            n.setColor(-13421773);
            ClientNotifications.add(n);
            return null;
        }
        long ms = LMUtils.millis();
        FTBWorld.client.readReloadData(this.io);
        MessageReload.readSyncedConfig(this.io);
        if (reload > 0) {
            MessageReload.reloadClient(ms, reload > 1);
        }
        return null;
    }

    public static void reloadClient(long ms, boolean printMessage) {
        if (ms == 0L) {
            ms = LMUtils.millis();
        }
        GameModes.reload();
        EntityPlayer ep = FTBLibMod.proxy.getClientPlayer();
        EventFTBReload event = new EventFTBReload(FTBWorld.client, (ICommandSender)ep, true);
        if (FTBLib.ftbu != null) {
            FTBLib.ftbu.onReloaded(event);
        }
        event.post();
        if (printMessage) {
            FTBLib.printChat((ICommandSender)ep, FTBLibMod.mod.chatComponent("reloaded_client", LMUtils.millis() - ms + "ms"));
        }
        FTBLibMod.logger.info("Current Mode: " + FTBWorld.client.getMode());
    }

    static void writeSyncedConfig(ByteIOStream out) {
        NBTTagCompound tag = new NBTTagCompound();
        ConfigRegistry.synced.writeToNBT(tag, false);
        LMNBTUtils.writeTag(out, tag);
        if (FTBLib.DEV_ENV) {
            FTBLib.dev_logger.info("Synced config TX: " + ConfigRegistry.synced.func_151003_a());
        }
    }

    static void readSyncedConfig(ByteIOStream in) {
        NBTTagCompound tag = LMNBTUtils.readTag(in);
        ConfigGroup synced = new ConfigGroup(ConfigRegistry.synced.getID());
        synced.readFromNBT(tag, false);
        ConfigRegistry.synced.loadFromGroup(synced, true);
        if (FTBLib.DEV_ENV) {
            FTBLib.dev_logger.info("Synced config RX: " + synced.func_151003_a());
        }
    }
}

