/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.cmd;

import ftb.lib.FTBLib;
import ftb.lib.LMAccessToken;
import ftb.lib.api.cmd.CommandLM;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigFile;
import ftb.lib.api.config.ConfigGroup;
import ftb.lib.api.config.ConfigRegistry;
import ftb.lib.mod.FTBLibMod;
import ftb.lib.mod.config.FTBLibConfigCmdNames;
import ftb.lib.mod.net.MessageEditConfig;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMListUtils;
import latmod.lib.LMStringUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CmdEditConfig
extends CommandLM {
    public CmdEditConfig() {
        super(FTBLibConfigCmdNames.edit_config.getAsString(), CommandLevel.OP);
    }

    @Override
    public String func_71518_a(ICommandSender ics) {
        return "/" + this.commandName + " <ID> [group] [entry] [value]";
    }

    @Override
    public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
        ConfigGroup group;
        ConfigFile file;
        if (i == 0) {
            return LMListUtils.toStringArray(ConfigRegistry.map.keySet());
        }
        if (i == 1) {
            ConfigFile file2 = ConfigRegistry.map.get(args[0]);
            if (file2 != null) {
                return LMListUtils.toStringArray(file2.entryMap.keySet());
            }
        } else if (i == 2 && (file = ConfigRegistry.map.get(args[0])) != null && (group = file.getGroup(args[1])) != null) {
            return LMListUtils.toStringArray(group.entryMap.keySet());
        }
        return null;
    }

    @Override
    public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
        ConfigEntry entry;
        CmdEditConfig.checkArgs(args, 1);
        if (args.length == 1 && ics instanceof EntityPlayerMP) {
            EntityPlayerMP ep = CmdEditConfig.func_71521_c((ICommandSender)ics);
            ConfigFile file = ConfigRegistry.map.get(args[0]);
            if (file == null) {
                return CmdEditConfig.error((IChatComponent)new ChatComponentText("Invalid file: '" + args[0] + "'!"));
            }
            new MessageEditConfig(LMAccessToken.generate(ep), true, file).sendTo(ep);
            return null;
        }
        CmdEditConfig.checkArgs(args, 3);
        ConfigFile file = ConfigRegistry.map.get(args[0]);
        if (file == null) {
            return CmdEditConfig.error((IChatComponent)new ChatComponentText("Can only edit files!"));
        }
        boolean success = false;
        ConfigGroup group = file.getGroup(args[1]);
        ConfigEntry configEntry = entry = group == null ? null : group.getEntry(args[2]);
        if (entry == null) {
            return CmdEditConfig.error((IChatComponent)new ChatComponentText("Can't find config entry '" + args[0] + " " + args[1] + " " + args[2] + "'"));
        }
        if (args.length >= 4) {
            String json = LMStringUtils.unsplitSpaceUntilEnd(3, args);
            FTBLibMod.logger.info("Setting " + args[0] + " " + args[1] + " " + args[2] + " to " + json);
            try {
                entry.func_152753_a(LMJsonUtils.fromJson(json));
                file.save();
                FTBLib.reload(ics, true, false);
                return new ChatComponentText(args[2] + " set to " + entry.getAsString());
            }
            catch (Exception ex) {
                ChatComponentText error = new ChatComponentText(ex.toString());
                error.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                return error;
            }
        }
        return new ChatComponentText(entry.getAsString());
    }
}

