/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.IClickable;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryColor;
import ftb.lib.api.config.ConfigEntryDouble;
import ftb.lib.api.config.ConfigEntryInt;
import ftb.lib.api.config.ConfigEntryString;
import ftb.lib.api.config.ConfigEntryType;
import ftb.lib.api.config.ConfigGroup;
import ftb.lib.api.config.IConfigProvider;
import ftb.lib.api.gui.GuiIcons;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.IClientActionGui;
import ftb.lib.api.gui.LMGuis;
import ftb.lib.api.gui.callback.ColorSelected;
import ftb.lib.api.gui.callback.FieldSelected;
import ftb.lib.api.gui.callback.IColorCallback;
import ftb.lib.api.gui.callback.IFieldCallback;
import ftb.lib.api.gui.widgets.ButtonLM;
import ftb.lib.api.gui.widgets.PanelLM;
import ftb.lib.api.gui.widgets.SliderLM;
import ftb.lib.api.gui.widgets.WidgetLM;
import java.util.ArrayList;
import java.util.List;
import latmod.lib.LMColorUtils;
import latmod.lib.LMJsonUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;

@SideOnly(value=Side.CLIENT)
public class GuiEditConfig
extends GuiLM
implements IClientActionGui {
    public final IConfigProvider provider;
    public final String title;
    public final ArrayList<ButtonConfigEntry> configEntryButtons;
    public final PanelLM configPanel;
    public final ButtonLM buttonClose;
    public final ButtonLM buttonExpandAll;
    public final ButtonLM buttonCollapseAll;
    public final SliderLM scroll;
    private boolean changed = false;
    private boolean shouldClose = false;

    public GuiEditConfig(GuiScreen g, IConfigProvider p) {
        super(g, null);
        this.provider = p;
        this.title = p.getConfigGroup().getDisplayName();
        this.configEntryButtons = new ArrayList();
        this.configPanel = new PanelLM(this, 0, 0, 0, 20){

            @Override
            public void addWidgets() {
                this.height = 0;
                for (ButtonConfigEntry b : GuiEditConfig.this.configEntryButtons) {
                    this.addCE(b);
                }
            }

            @Override
            public void renderWidget() {
                for (int i = 0; i < this.widgets.size(); ++i) {
                    ((WidgetLM)this.widgets.get(i)).renderWidget();
                }
            }

            private void addCE(ButtonConfigEntry e) {
                this.add(e);
                e.posY = this.height;
                this.height += e.height;
                if (e.expanded) {
                    for (ButtonConfigEntry b : e.subButtons) {
                        this.addCE(b);
                    }
                }
            }
        };
        this.buttonClose = new ButtonLM(this, 0, 2, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                GuiEditConfig.this.shouldClose = true;
                GuiEditConfig.this.close(null);
            }
        };
        this.buttonExpandAll = new ButtonLM(this, 2, 2, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                for (ButtonConfigEntry e : GuiEditConfig.this.configEntryButtons) {
                    this.expandAll(e);
                }
                this.gui.refreshWidgets();
            }

            private void expandAll(ButtonConfigEntry e) {
                if (e.entry.getAsGroup() != null) {
                    e.expanded = true;
                    for (ButtonConfigEntry e1 : e.subButtons) {
                        this.expandAll(e1);
                    }
                }
            }
        };
        this.buttonCollapseAll = new ButtonLM(this, 20, 2, 16, 16){

            @Override
            public void onButtonPressed(int b) {
                FTBLibClient.playClickSound();
                for (ButtonConfigEntry e : GuiEditConfig.this.configEntryButtons) {
                    this.collapseAll(e);
                }
                this.gui.refreshWidgets();
            }

            private void collapseAll(ButtonConfigEntry e) {
                if (e.entry.getAsGroup() != null) {
                    e.expanded = false;
                    for (ButtonConfigEntry e1 : e.subButtons) {
                        this.collapseAll(e1);
                    }
                }
            }
        };
        this.scroll = new SliderLM(this, -16, 20, 16, 0, 10){

            @Override
            public boolean canMouseScroll() {
                return true;
            }
        };
        this.scroll.isVertical = true;
        this.scroll.displayMax = 0;
        this.scroll.displayMin = 0;
    }

    @Override
    public void initLMGui() {
        this.mainPanel.width = this.field_146294_l;
        this.mainPanel.height = this.field_146295_m;
        this.mainPanel.posY = 0;
        this.mainPanel.posX = 0;
        this.buttonClose.posX = this.field_146294_l - 18;
        this.scroll.posX = this.field_146294_l - 16;
        this.scroll.height = this.field_146295_m - 20;
        this.configPanel.posY = 20;
        this.scroll.value = 0.0f;
        if (this.configEntryButtons.isEmpty()) {
            this.configEntryButtons.clear();
            for (ConfigEntry entry : this.provider.getConfigGroup().sortedEntries()) {
                this.addCE(null, entry, 0);
            }
        }
    }

    private void addCE(ButtonConfigEntry parent, ConfigEntry e, int level) {
        if (!e.getFlag((byte)1)) {
            ButtonConfigEntry b = new ButtonConfigEntry(this, e);
            b.posX += level * 12;
            b.width -= level * 12;
            if (parent == null) {
                b.expanded = true;
                this.configEntryButtons.add(b);
            } else {
                parent.subButtons.add(b);
            }
            ConfigGroup g = e.getAsGroup();
            if (g != null) {
                for (ConfigEntry entry : g.sortedEntries()) {
                    this.addCE(b, entry, level + 1);
                }
            }
        }
    }

    @Override
    public void addWidgets() {
        this.configPanel.height = 20;
        this.configPanel.width = this.field_146294_l;
        this.configPanel.posX = 0;
        this.configPanel.posY = 20;
        this.mainPanel.add(this.buttonClose);
        this.mainPanel.add(this.buttonExpandAll);
        this.mainPanel.add(this.buttonCollapseAll);
        this.mainPanel.add(this.configPanel);
        this.mainPanel.add(this.scroll);
    }

    @Override
    public void onLMGuiClosed() {
        if (this.shouldClose && this.changed) {
            this.provider.save();
        }
    }

    @Override
    public void onClosedByKey() {
        this.shouldClose = true;
        super.onClosedByKey();
    }

    public void onChanged() {
        this.changed = true;
    }

    @Override
    public void drawBackground() {
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.configPanel.height + 20 > this.field_146295_m) {
            this.scroll.scrollStep = 40.0f / ((float)this.configPanel.height + 20.0f);
            this.scroll.update();
            this.configPanel.posY = (int)(this.scroll.value * (float)(this.field_146295_m - this.configPanel.height - 20)) + 20;
        } else {
            this.scroll.value = 0.0f;
            this.configPanel.posY = 20;
        }
        this.configPanel.renderWidget();
        GuiEditConfig.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)20, (int)-1724697805);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 6, -1);
        GuiEditConfig.func_73734_a((int)this.scroll.posX, (int)this.scroll.posY, (int)(this.scroll.posX + this.scroll.width), (int)(this.scroll.posY + this.scroll.height), (int)-1724697805);
        int sy = (int)((float)this.scroll.posY + this.scroll.value * (float)(this.scroll.height - this.scroll.sliderSize));
        GuiEditConfig.func_73734_a((int)this.scroll.posX, (int)sy, (int)(this.scroll.posX + this.scroll.width), (int)(sy + this.scroll.sliderSize), (int)-1721342362);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.buttonClose.render(GuiIcons.accept);
        this.buttonExpandAll.render(GuiIcons.add);
        this.buttonCollapseAll.render(GuiIcons.remove);
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    public static class ButtonConfigEntry
    extends ButtonLM {
        public final GuiEditConfig gui;
        public final ConfigEntry entry;
        public boolean expanded = false;
        public final ArrayList<ButtonConfigEntry> subButtons;

        public ButtonConfigEntry(GuiEditConfig g, ConfigEntry e) {
            super(g, 0, g.configPanel.height, g.field_146294_l - 16, 16);
            this.gui = g;
            this.entry = e;
            this.title = g.provider.getEntryTitle(this.entry);
            this.subButtons = new ArrayList();
        }

        public boolean isVisible() {
            int ay = this.getAY();
            return ay > -this.height && ay < this.gui.field_146295_m;
        }

        @Override
        public void renderWidget() {
            boolean isGroup;
            if (!this.isVisible()) {
                return;
            }
            boolean mouseOver = this.gui.mouse().y >= 20 && this.mouseOver();
            int ax = this.getAX();
            int ay = this.getAY();
            boolean bl = isGroup = this.entry.getAsGroup() != null;
            if (mouseOver) {
                GlStateManager.color(1.0f, 1.0f, 1.0f, 0.13f);
                GuiLM.drawBlankRect(ax, ay, this.gui.field_73735_i, this.width, this.height);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            this.gui.func_73731_b(this.gui.field_146289_q, isGroup ? (this.expanded ? "[-] " : "[+] ") + this.title : this.title, ax + 4, ay + 4, mouseOver ? -1 : (isGroup ? -3355444 : -6710887));
            if (!isGroup) {
                String s = this.entry.getAsString();
                int slen = this.gui.field_146289_q.func_78256_a(s);
                if (slen > 150) {
                    s = this.gui.field_146289_q.func_78269_a(s, 150) + "...";
                    slen = 152;
                }
                int textCol = 0xFF000000 | this.entry.getColor();
                if (mouseOver) {
                    textCol = LMColorUtils.addBrightness(textCol, 60);
                }
                if (mouseOver && this.gui.mouse().x > ax + this.width - slen - 9) {
                    GlStateManager.color(1.0f, 1.0f, 1.0f, 0.13f);
                    GuiLM.drawBlankRect(ax + this.width - slen - 8, ay, this.gui.field_73735_i, slen + 8, this.height);
                    GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                }
                this.gui.func_73731_b(this.gui.field_146289_q, s, this.gui.field_146294_l - (slen + 20), ay + 4, textCol);
            }
        }

        @Override
        public void onButtonPressed(int b) {
            if (this.gui.mouse().y < 20) {
                return;
            }
            FTBLibClient.playClickSound();
            if (this.entry.getFlag((byte)2)) {
                return;
            }
            ConfigEntryType type = this.entry.getConfigType();
            if (this.entry instanceof IClickable) {
                ((IClickable)((Object)this.entry)).onClicked(b == 0);
                this.gui.onChanged();
            } else if (this.entry.getAsGroup() != null) {
                this.expanded = !this.expanded;
                this.gui.refreshWidgets();
            } else if (type == ConfigEntryType.COLOR) {
                LMGuis.displayColorSelector(new IColorCallback(){

                    @Override
                    public void onColorSelected(ColorSelected c) {
                        if (c.set) {
                            ((ConfigEntryColor)entry).value.set(c.color);
                            gui.onChanged();
                        }
                        if (c.closeGui) {
                            FTBLibClient.openGui(gui);
                        }
                    }
                }, ((ConfigEntryColor)this.entry).value, 0, false);
            } else if (type == ConfigEntryType.INT) {
                LMGuis.displayFieldSelector(this.entry.getFullID(), LMGuis.FieldType.INTEGER, this.entry.getAsInt(), new IFieldCallback(){

                    @Override
                    public void onFieldSelected(FieldSelected c) {
                        if (c.set) {
                            ((ConfigEntryInt)entry).set(c.resultI());
                            gui.onChanged();
                        }
                        if (c.closeGui) {
                            FTBLibClient.openGui(gui);
                        }
                    }
                });
            } else if (type == ConfigEntryType.DOUBLE) {
                LMGuis.displayFieldSelector(this.entry.getFullID(), LMGuis.FieldType.DOUBLE, this.entry.getAsDouble(), new IFieldCallback(){

                    @Override
                    public void onFieldSelected(FieldSelected c) {
                        if (c.set) {
                            ((ConfigEntryDouble)entry).set(c.resultD());
                            gui.onChanged();
                        }
                        if (c.closeGui) {
                            FTBLibClient.openGui(gui);
                        }
                    }
                });
            } else if (type == ConfigEntryType.STRING) {
                LMGuis.displayFieldSelector(this.entry.getFullID(), LMGuis.FieldType.STRING, this.entry.getAsString(), new IFieldCallback(){

                    @Override
                    public void onFieldSelected(FieldSelected c) {
                        if (c.set) {
                            ((ConfigEntryString)entry).set(c.result);
                            gui.onChanged();
                        }
                        if (c.closeGui) {
                            FTBLibClient.openGui(gui);
                        }
                    }
                });
            } else if (type == ConfigEntryType.CUSTOM || type == ConfigEntryType.INT_ARRAY || type == ConfigEntryType.STRING_ARRAY) {
                LMGuis.displayFieldSelector(this.entry.getFullID(), LMGuis.FieldType.STRING, this.entry.func_151003_a().toString(), new IFieldCallback(){

                    @Override
                    public void onFieldSelected(FieldSelected c) {
                        if (c.set) {
                            entry.func_152753_a(LMJsonUtils.fromJson(c.result));
                            gui.onChanged();
                        }
                        if (c.closeGui) {
                            FTBLibClient.openGui(gui);
                        }
                    }
                });
            }
        }

        @Override
        public void addMouseOverText(List<String> l) {
            String[] info;
            if (this.gui.mouse().x < this.gui.field_146289_q.func_78256_a(this.title) + 10 && (info = this.entry.getInfo()) != null && info.length > 0) {
                for (String s : info) {
                    l.addAll(FTBLibClient.mc.field_71466_p.func_78271_c(s, 230));
                }
            }
            if (this.entry.getAsGroup() == null && this.gui.mouse().x > this.gui.field_146294_l - (Math.min(150, this.gui.field_146289_q.func_78256_a(this.entry.getAsString())) + 25)) {
                String def = this.entry.getDefValueString();
                String min = this.entry.getMinValueString();
                String max = this.entry.getMaxValueString();
                if (def != null) {
                    l.add(EnumChatFormatting.AQUA + "Def: " + def);
                }
                if (min != null) {
                    l.add(EnumChatFormatting.AQUA + "Min: " + min);
                }
                if (max != null) {
                    l.add(EnumChatFormatting.AQUA + "Max: " + max);
                }
            }
        }
    }
}

