/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.EnumScreen;
import ftb.lib.EventBusHelper;
import ftb.lib.FTBLib;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.config.ClientConfigRegistry;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.lib.api.config.ConfigEntryEnum;
import ftb.lib.api.config.ConfigEntryString;
import ftb.lib.api.gui.LMGuiHandler;
import ftb.lib.api.gui.LMGuiHandlerRegistry;
import ftb.lib.api.gui.PlayerActionRegistry;
import ftb.lib.api.tile.IGuiTile;
import ftb.lib.mod.FTBLibModCommon;
import ftb.lib.mod.client.FTBLibActions;
import ftb.lib.mod.client.FTBLibClientEventHandler;
import ftb.lib.mod.client.FTBLibGuiHandler;
import ftb.lib.mod.client.FTBLibRenderHandler;
import ftb.lib.mod.cmd.CmdReloadClient;
import java.util.UUID;
import latmod.lib.LMColorUtils;
import latmod.lib.LMUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class FTBLibModClient
extends FTBLibModCommon {
    public static final ConfigEntryBool item_ore_names = new ConfigEntryBool("item_ore_names", false);
    public static final ConfigEntryBool item_reg_names = new ConfigEntryBool("item_reg_names", false);
    public static final ConfigEntryEnum<EnumScreen> notifications = new ConfigEntryEnum("notifications", (Enum[])EnumScreen.values(), (Enum)EnumScreen.SCREEN, false);
    public static final ConfigEntryString reload_client_cmd = new ConfigEntryString("reload_client_cmd", "reload_client");

    @Override
    public void preInit() {
        EventBusHelper.register(FTBLibClientEventHandler.instance);
        EventBusHelper.register(FTBLibRenderHandler.instance);
        LMGuiHandlerRegistry.add(FTBLibGuiHandler.instance);
        FTBLib.userIsLatvianModder = FTBLibClient.mc.func_110432_I().func_148256_e().getId().equals(LMUtils.fromString("5afb9a5b207d480e887967bc848f9a8f"));
        ClientConfigRegistry.addGroup("ftbl", FTBLibModClient.class);
        ClientConfigRegistry.add(PlayerActionRegistry.configGroup);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CmdReloadClient());
        FTBLibActions.init();
    }

    @Override
    public void postInit() {
        ClientConfigRegistry.provider().getConfigGroup();
    }

    @Override
    public String translate(String key, Object ... obj) {
        return I18n.func_135052_a((String)key, (Object[])obj);
    }

    @Override
    public boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiScreen.func_146271_m();
    }

    @Override
    public boolean isTabDown() {
        return Keyboard.isKeyDown((int)15);
    }

    @Override
    public boolean inGameHasFocus() {
        return FTBLibClient.mc.field_71415_G;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    @Override
    public EntityPlayer getClientPlayer(UUID id) {
        return FTBLibClient.getPlayerSP(id);
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getWorldClient();
    }

    @Override
    public double getReachDist(EntityPlayer ep) {
        if (ep == null) {
            return 0.0;
        }
        if (ep instanceof EntityPlayerMP) {
            return super.getReachDist(ep);
        }
        PlayerControllerMP c = FTBLibClient.mc.field_71442_b;
        return c == null ? 0.0 : (double)c.func_78757_d();
    }

    @Override
    public void spawnDust(World w, double x, double y, double z, int col) {
        EntityReddustFX fx = new EntityReddustFX(w, x, y, z, 0.0f, 0.0f, 0.0f){};
        float alpha = (float)LMColorUtils.getAlpha(col) / 255.0f;
        float red = (float)LMColorUtils.getRed(col) / 255.0f;
        float green = (float)LMColorUtils.getGreen(col) / 255.0f;
        float blue = (float)LMColorUtils.getBlue(col) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        fx.func_70538_b(red, green, blue);
        fx.func_82338_g(alpha);
        FTBLibClient.mc.field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public boolean openClientGui(EntityPlayer ep, String mod, int id, NBTTagCompound data) {
        GuiScreen g;
        LMGuiHandler h = LMGuiHandlerRegistry.get(mod);
        if (h != null && (g = h.getGui(ep, id, data)) != null) {
            FTBLibClient.openGui(g);
            return true;
        }
        return false;
    }

    @Override
    public void openClientTileGui(EntityPlayer ep, IGuiTile t, NBTTagCompound data) {
        GuiScreen g;
        if (ep != null && t != null && (g = t.getGui(ep, data)) != null) {
            FTBLibClient.openGui(g);
        }
    }
}

