/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import ftb.lib.EventBusHelper;
import ftb.lib.FTBLib;
import ftb.lib.FTBWorld;
import ftb.lib.JsonHelper;
import ftb.lib.LMAccessToken;
import ftb.lib.LMMod;
import ftb.lib.api.EventFTBWorldServer;
import ftb.lib.api.GameModes;
import ftb.lib.api.config.ConfigRegistry;
import ftb.lib.api.item.ODItems;
import ftb.lib.mod.FTBLibEventHandler;
import ftb.lib.mod.FTBLibModCommon;
import ftb.lib.mod.cmd.CmdEditConfig;
import ftb.lib.mod.cmd.CmdHelpOverride;
import ftb.lib.mod.cmd.CmdListOverride;
import ftb.lib.mod.cmd.CmdMode;
import ftb.lib.mod.cmd.CmdNotify;
import ftb.lib.mod.cmd.CmdReload;
import ftb.lib.mod.cmd.CmdSetItemName;
import ftb.lib.mod.cmd.CmdTrashCan;
import ftb.lib.mod.config.FTBLibConfig;
import ftb.lib.mod.config.FTBLibConfigCmd;
import ftb.lib.mod.net.FTBLibNetHandler;
import java.io.File;
import java.util.Map;
import latmod.lib.util.OS;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="FTBL", name="FTBLib", version="1.0.19-GTNH", dependencies="required-after:Forge@[10.13.4.1558,);after:Baubles;after:NotEnoughItems;after:Waila;after:MineTweaker3", acceptedMinecraftVersions="1.7.10")
public class FTBLibMod {
    @Mod.Instance(value="FTBL")
    public static FTBLibMod inst;
    @SidedProxy(serverSide="ftb.lib.mod.FTBLibModCommon", clientSide="ftb.lib.mod.client.FTBLibModClient")
    public static FTBLibModCommon proxy;
    public static final Logger logger;
    public static LMMod mod;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        if (FTBLib.DEV_ENV) {
            logger.info("Loading FTBLib, DevEnv");
        } else {
            logger.info("Loading FTBLib, v1.0.19-GTNH");
        }
        logger.info("OS: " + (Object)((Object)OS.current) + ", 64bit: " + OS.is64);
        mod = LMMod.create("FTBL");
        FTBLib.init(e.getModConfigurationDirectory());
        JsonHelper.init();
        FTBLibNetHandler.init();
        ODItems.preInit();
        FTBLibConfig.load();
        EventBusHelper.register(new FTBLibEventHandler());
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"ftb.lib.api.waila.EventRegisterWaila.registerHandlers");
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        ODItems.postInit();
        proxy.postInit();
        GameModes.reload();
        ConfigRegistry.reload();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        if (FTBLibConfigCmd.override_list.getAsBoolean()) {
            FTBLib.addCommand(e, (ICommand)new CmdListOverride());
        }
        if (FTBLibConfigCmd.override_help.getAsBoolean()) {
            FTBLib.addCommand(e, (ICommand)new CmdHelpOverride());
        }
        FTBLib.addCommand(e, (ICommand)new CmdEditConfig());
        FTBLib.addCommand(e, (ICommand)new CmdMode());
        FTBLib.addCommand(e, (ICommand)new CmdReload());
        FTBLib.addCommand(e, (ICommand)new CmdNotify());
        FTBLib.addCommand(e, (ICommand)new CmdSetItemName());
        FTBLib.addCommand(e, (ICommand)new CmdTrashCan());
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent e) {
        FTBLib.folderWorld = new File(FMLCommonHandler.instance().getSavesDirectory(), e.getServer().func_71270_I());
        ConfigRegistry.reload();
        GameModes.reload();
        FTBWorld.server = new FTBWorld(Side.SERVER);
        EventFTBWorldServer event = new EventFTBWorldServer(FTBWorld.server, e.getServer());
        if (FTBLib.ftbu != null) {
            FTBLib.ftbu.onFTBWorldServer(event);
        }
        event.post();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent e) {
        FTBLib.reload((ICommandSender)FTBLib.getServer(), false, false);
    }

    @Mod.EventHandler
    public void onServerShutDown(FMLServerStoppedEvent e) {
        if (FTBLib.ftbu != null) {
            FTBLib.ftbu.onFTBWorldServerClosed();
        }
        FTBWorld.server = null;
        FTBLib.folderWorld = null;
        LMAccessToken.clear();
        ConfigRegistry.clearTemp();
    }

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> m, Side side) {
        String s = m.get("FTBL");
        return s == null || s.equals("1.0.19-GTNH");
    }

    static {
        logger = LogManager.getLogger((String)"FTBLib");
    }
}

