/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.net;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.net.LMNetworkWrapper;
import io.netty.buffer.ByteBuf;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MessageLM
implements IMessage,
IMessageHandler<MessageLM, IMessage> {
    public final ByteCount dataType;
    public ByteIOStream io;

    public final NBTTagCompound readTag() {
        return LMNBTUtils.readTag(this.io);
    }

    public final void writeTag(NBTTagCompound tag) {
        LMNBTUtils.writeTag(this.io, tag);
    }

    public MessageLM(ByteCount t) {
        this.dataType = t;
        if (t != null) {
            this.io = new ByteIOStream();
        }
    }

    public abstract LMNetworkWrapper getWrapper();

    public IMessage onMessage(MessageContext ctx) {
        return null;
    }

    public final void fromBytes(ByteBuf bb) {
        if (this.dataType == null) {
            return;
        }
        int len = 0;
        if (this.dataType == ByteCount.BYTE) {
            len = bb.readByte() & 0xFF;
        } else if (this.dataType == ByteCount.SHORT) {
            len = bb.readShort() & 0xFFFF;
        } else if (this.dataType == ByteCount.INT) {
            len = bb.readInt();
        }
        byte[] b = new byte[len];
        bb.readBytes(b, 0, len);
        if (this.dataType == ByteCount.BYTE) {
            this.io.setData(b);
        } else {
            this.io.setCompressedData(b);
        }
    }

    public final void toBytes(ByteBuf bb) {
        byte[] b;
        if (this.dataType == null) {
            return;
        }
        byte[] byArray = b = this.dataType == ByteCount.BYTE ? this.io.toByteArray() : this.io.toCompressedByteArray();
        if (this.dataType == ByteCount.BYTE) {
            bb.writeByte((int)((byte)b.length));
        } else if (this.dataType == ByteCount.SHORT) {
            bb.writeShort((int)((short)b.length));
        } else if (this.dataType == ByteCount.INT) {
            bb.writeInt(b.length);
        }
        bb.writeBytes(b, 0, b.length);
    }

    public final IMessage onMessage(MessageLM m, MessageContext ctx) {
        this.io = m.io;
        return this.onMessage(ctx);
    }

    public final void sendTo(EntityPlayerMP ep) {
        if (ep != null) {
            this.getWrapper().sendTo(this, ep);
        } else {
            this.getWrapper().sendToAll(this);
        }
    }

    public final void sendToServer() {
        this.getWrapper().sendToServer(this);
    }
}

