/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.item;

import ftb.lib.api.item.LMInvUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StringIDInvLoader {
    public static void readItemsFromNBT(ItemStack[] items, NBTTagCompound tag, String s) {
        if (items == null || items.length == 0) {
            return;
        }
        Arrays.fill(items, null);
        if (tag.func_74764_b(s)) {
            NBTTagList list = tag.func_150295_c(s, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int key;
                NBTTagCompound tag1 = list.func_150305_b(i);
                Map.Entry<Integer, ItemStack> itemEntry = StringIDInvLoader.loadFromNBT(tag1);
                if (itemEntry == null || (key = itemEntry.getKey().intValue()) < 0 || key >= items.length) continue;
                items[key] = itemEntry.getValue();
            }
        }
    }

    public static void writeItemsToNBT(ItemStack[] items, NBTTagCompound tag, String s) {
        if (items == null || items.length == 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            list.func_74742_a((NBTBase)StringIDInvLoader.saveToNBT(items[i], i));
        }
        if (list.func_74745_c() > 0) {
            tag.func_74782_a(s, (NBTBase)list);
        }
    }

    public static void readInvFromNBT(IInventory inv, NBTTagCompound tag, String s) {
        if (inv == null) {
            return;
        }
        ItemStack[] items = new ItemStack[inv.func_70302_i_()];
        StringIDInvLoader.readItemsFromNBT(items, tag, s);
        for (int i = 0; i < items.length; ++i) {
            inv.func_70299_a(i, items[i]);
        }
        inv.func_70296_d();
    }

    public static void writeInvToNBT(IInventory inv, NBTTagCompound tag, String s) {
        if (inv == null) {
            return;
        }
        ItemStack[] items = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = inv.func_70301_a(i);
        }
        StringIDInvLoader.writeItemsToNBT(items, tag, s);
    }

    public static int getSlotsUsed(NBTTagCompound tag, String s) {
        return tag.func_74764_b(s) ? tag.func_150295_c(s, 10).func_74745_c() : 0;
    }

    public static int getItemCount(NBTTagCompound tag, String s) {
        int count = 0;
        if (tag.func_74764_b(s)) {
            NBTTagList list = tag.func_150295_c(s, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag1 = list.func_150305_b(i);
                if (tag1.func_74764_b("S")) {
                    count += tag1.func_74771_c("C");
                    continue;
                }
                int[] ai = tag1.func_74759_k("D");
                if (ai.length != 3) continue;
                count += ai[1];
            }
        }
        return count;
    }

    public static Map.Entry<Integer, ItemStack> loadFromNBT(NBTTagCompound tag) {
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        if (tag.func_74764_b("Slot")) {
            short slot = tag.func_74765_d("Slot");
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (is != null) {
                return new AbstractMap.SimpleEntry<Integer, ItemStack>(Integer.valueOf(slot), is);
            }
        } else {
            Item item = LMInvUtils.getItemFromRegName(tag.func_74779_i("ID"));
            if (item != null) {
                if (tag.func_74764_b("S")) {
                    short slot = tag.func_74765_d("S");
                    byte size = tag.func_74771_c("C");
                    int dmg = Math.max(0, tag.func_74765_d("D"));
                    ItemStack is = new ItemStack(item, (int)size, dmg);
                    if (tag.func_74764_b("T")) {
                        is.func_77982_d(tag.func_74775_l("T"));
                    }
                    return new AbstractMap.SimpleEntry<Integer, ItemStack>(Integer.valueOf(slot), is);
                }
                int[] ai = tag.func_74759_k("D");
                if (ai.length == 3) {
                    ItemStack is = new ItemStack(item, ai[1], ai[2]);
                    if (tag.func_150297_b("T", 10)) {
                        is.func_77982_d(tag.func_74775_l("T"));
                    }
                    return new AbstractMap.SimpleEntry<Integer, ItemStack>(ai[0], is);
                }
            }
        }
        return null;
    }

    public static NBTTagCompound saveToNBT(ItemStack is, int slot) {
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ID", LMInvUtils.getRegName(is.func_77973_b()).toString());
        tag.func_74783_a("D", new int[]{slot, is.field_77994_a, is.func_77960_j()});
        if (is.func_77942_o()) {
            tag.func_74782_a("T", (NBTBase)is.func_77978_p());
        }
        return tag;
    }
}

