/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.TextureCoords;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.widgets.PanelLM;
import java.util.List;

@SideOnly(value=Side.CLIENT)
public class WidgetLM {
    public final IGuiLM gui;
    public int posX;
    public int posY;
    public int width;
    public int height;
    public PanelLM parentPanel = null;
    public String title = null;

    public WidgetLM(IGuiLM g, int x, int y, int w, int h) {
        this.gui = g;
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getAX() {
        return this.parentPanel == null ? this.posX : this.parentPanel.getAX() + this.posX;
    }

    public int getAY() {
        return this.parentPanel == null ? this.posY : this.parentPanel.getAY() + this.posY;
    }

    protected boolean mouseOver(int ax, int ay) {
        return this.gui.mouse().isInside(ax, ay, this.width, this.height);
    }

    public boolean mouseOver() {
        return this.mouseOver(this.getAX(), this.getAY());
    }

    public void render(TextureCoords icon, double rw, double rh) {
        GuiLM.render(icon, this.getAX(), this.getAY(), this.gui.getZLevel(), (int)((double)this.width * rw), (int)((double)this.height * rh));
    }

    public void render(TextureCoords icon) {
        this.render(icon, 1.0, 1.0);
    }

    public void mousePressed(int b) {
    }

    public boolean keyPressed(int key, char keyChar) {
        return false;
    }

    public void addMouseOverText(List<String> l) {
        if (this.title != null) {
            l.add(this.title);
        }
    }

    public void renderWidget() {
    }
}

