/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.TextureCoords;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.widgets.WidgetLM;
import java.util.List;
import latmod.lib.MathHelperLM;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class SliderLM
extends WidgetLM {
    public boolean isGrabbed;
    public float value;
    public final int sliderSize;
    public int displayMin = 0;
    public int displayMax = 0;
    public boolean isVertical = false;
    public float scrollStep = 0.1f;

    public SliderLM(IGuiLM g, int x, int y, int w, int h, int ss) {
        super(g, x, y, w, h);
        this.sliderSize = ss;
    }

    public void update() {
        float v0 = this.value;
        if (this.isGrabbed) {
            if (Mouse.isButtonDown((int)0)) {
                this.value = this.isVertical ? ((float)this.gui.mouse().y - ((float)this.getAY() + (float)this.sliderSize / 2.0f)) / (float)(this.height - this.sliderSize) : ((float)this.gui.mouse().x - ((float)this.getAX() + (float)this.sliderSize / 2.0f)) / (float)(this.width - this.sliderSize);
            } else {
                this.isGrabbed = false;
                this.onReleased();
            }
        }
        if (this.gui.mouse().dwheel != 0 && this.canMouseScroll()) {
            this.value += this.gui.mouse().dwheel < 0 ? this.scrollStep : -this.scrollStep;
        }
        this.value = MathHelperLM.clampFloat(this.value, 0.0f, 1.0f);
        if (v0 != this.value) {
            this.onMoved();
        }
    }

    public void onMoved() {
    }

    public void onReleased() {
    }

    public boolean canMouseScroll() {
        return this.mouseOver();
    }

    public int getValueI() {
        return (int)(this.value * (float)((this.isVertical ? this.height : this.width) - this.sliderSize));
    }

    public void renderSlider(TextureCoords tc) {
        if (this.isVertical) {
            GuiLM.render(tc, this.getAX(), this.getAY() + this.getValueI(), this.gui.getZLevel(), this.width, this.sliderSize);
        } else {
            GuiLM.render(tc, this.getAX() + this.getValueI(), this.getAY(), this.gui.getZLevel(), this.sliderSize, this.height);
        }
    }

    @Override
    public void mousePressed(int b) {
        if (this.mouseOver() && b == 0) {
            this.isGrabbed = true;
        }
    }

    @Override
    public void addMouseOverText(List<String> l) {
        if (this.displayMin == 0 && this.displayMax == 0) {
            return;
        }
        String s = "" + (int)MathHelperLM.map(this.value, 0.0, 1.0, this.displayMin, this.displayMax);
        if (this.title != null) {
            s = this.title + ": " + s;
        }
        l.add(s);
    }
}

