/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.gui.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.widgets.WidgetLM;
import java.util.ArrayList;
import java.util.List;

@SideOnly(value=Side.CLIENT)
public abstract class PanelLM
extends WidgetLM {
    public final List<WidgetLM> widgets = new ArrayList<WidgetLM>();
    protected final List<PanelLM> childPanels = new ArrayList<PanelLM>();

    public PanelLM(IGuiLM g, int x, int y, int w, int h) {
        super(g, x, y, w, h);
    }

    public abstract void addWidgets();

    public void add(WidgetLM w) {
        if (w == null) {
            return;
        }
        w.parentPanel = this;
        this.widgets.add(w);
        if (w instanceof PanelLM) {
            PanelLM p = (PanelLM)w;
            this.childPanels.add(p);
            p.refreshWidgets();
        }
    }

    public void addAll(WidgetLM[] l) {
        if (l == null || l.length == 0) {
            return;
        }
        for (int i = 0; i < l.length; ++i) {
            this.add(l[i]);
        }
    }

    public void addAll(List<? extends WidgetLM> l) {
        if (l == null || l.isEmpty()) {
            return;
        }
        for (WidgetLM widgetLM : l) {
            this.add(widgetLM);
        }
    }

    public void refreshWidgets() {
        this.widgets.clear();
        this.addWidgets();
    }

    @Override
    public void addMouseOverText(List<String> l) {
        if (this.title != null) {
            l.add(this.title);
        }
        for (WidgetLM w : this.widgets) {
            if (!w.isEnabled() || !w.mouseOver()) continue;
            w.addMouseOverText(l);
        }
    }

    @Override
    public void mousePressed(int b) {
        for (WidgetLM w : this.widgets) {
            if (!w.isEnabled()) continue;
            w.mousePressed(b);
        }
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        for (WidgetLM w : this.widgets) {
            if (!w.isEnabled() || !w.keyPressed(key, keyChar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderWidget() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            this.widgets.get(i).renderWidget();
        }
    }
}

