/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.client.GlStateManager;
import ftb.lib.api.gui.ContainerLM;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.api.gui.IGuiLM;
import ftb.lib.api.gui.MouseLM;
import ftb.lib.api.gui.widgets.PanelLM;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public abstract class GuiContainerLM
extends GuiContainer
implements IGuiLM {
    private static final ArrayList<String> tempTextList = new ArrayList();
    private boolean refreshWidgets = true;
    public final ResourceLocation texture;
    public final ContainerLM container;
    public final PanelLM mainPanel;
    private final MouseLM mouse;
    public float delta;

    public GuiContainerLM(ContainerLM c, ResourceLocation tex) {
        super((Container)c);
        this.texture = tex;
        this.container = c;
        this.field_146297_k = FTBLibClient.mc;
        ScaledResolution scr = new ScaledResolution(this.field_146297_k, FTBLibClient.mc.field_71443_c, FTBLibClient.mc.field_71440_d);
        this.mainPanel = new PanelLM(this, 0, 0, scr.func_78326_a(), scr.func_78328_b()){

            @Override
            public void addWidgets() {
                GuiContainerLM.this.addWidgets();
            }
        };
        this.mainPanel.width = 176;
        this.mainPanel.height = 166;
        this.mouse = new MouseLM();
        this.refreshWidgets();
    }

    @Override
    public void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
        this.initLMGui();
        this.field_146999_f = this.mainPanel.width;
        this.field_147000_g = this.mainPanel.height;
        this.field_147003_i = this.mainPanel.posX = (this.field_146294_l - this.mainPanel.width) / 2;
        this.field_147009_r = this.mainPanel.posY = (this.field_146295_m - this.mainPanel.height) / 2;
        this.refreshWidgets();
    }

    @Override
    public void initLMGui() {
    }

    public abstract void addWidgets();

    public ItemStack getHeldItem() {
        return this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
    }

    @Override
    public GuiScreen getGui() {
        return this;
    }

    @Override
    public PanelLM getMainPanel() {
        return this.mainPanel;
    }

    @Override
    public MouseLM mouse() {
        return this.mouse;
    }

    @Override
    public final float getZLevel() {
        return this.field_73735_i;
    }

    @Override
    public final void setZLevel(float z) {
        this.field_73735_i = z;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public final void close(GuiScreen g) {
        FTBLibClient.openGui(g);
    }

    protected final void func_146976_a(float f, int mx, int my) {
    }

    protected final void func_73864_a(int mx, int my, int b) {
        this.mouse.onClicked(b, true);
        this.mainPanel.mousePressed(b);
        super.func_73864_a(mx, my, b);
        this.mouseClicked();
    }

    public void mouseClicked() {
    }

    protected void func_73869_a(char keyChar, int key) {
        if (this.mainPanel.keyPressed(key, keyChar)) {
            return;
        }
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.onClosedByKey();
        }
        super.func_73869_a(keyChar, key);
    }

    public void onClosedByKey() {
        this.close(null);
    }

    public void func_73729_b(int x, int y, int u, int v, int w, int h) {
        this.drawTexturedModalRectD(x, y, u, v, w, h);
    }

    public void drawTexturedModalRectD(double x, double y, double u, double v, double w, double h) {
        GuiLM.drawTexturedModalRectD(x, y, this.field_73735_i, u, v, w, h, 256, 256);
    }

    public void drawBackground() {
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.texture != null) {
            FTBLibClient.setTexture(this.texture);
            this.drawTexturedModalRectD(this.mainPanel.posX, this.mainPanel.posY, 0.0, 0.0, this.mainPanel.width, this.mainPanel.height);
        }
    }

    public void drawForeground() {
    }

    public final void func_73863_a(int mx, int my, float f) {
        this.mouse.onUpdate(mx, my);
        this.delta = f;
        if (this.refreshWidgets) {
            this.mainPanel.refreshWidgets();
            this.refreshWidgets = false;
        }
        GlStateManager.disableLighting();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.func_146276_q_();
        this.drawBackground();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        super.func_73863_a(mx, my, f);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        tempTextList.clear();
        this.drawText(tempTextList);
        if (!tempTextList.isEmpty()) {
            this.drawHoveringText(tempTextList, this.mouse.x, Math.max(this.mouse.y, 18), this.field_146289_q);
        }
        GlStateManager.disableLighting();
        this.drawForeground();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawText(List<String> l) {
        this.mainPanel.addMouseOverText(l);
    }

    public final void func_146281_b() {
        super.func_146281_b();
        this.onLMGuiClosed();
    }

    public void onLMGuiClosed() {
    }
}

