/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryCustom;
import ftb.lib.api.config.ConfigEntryType;
import ftb.lib.api.config.ConfigFile;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import latmod.lib.LMStringUtils;
import latmod.lib.LMUtils;
import latmod.lib.annotations.AnnotationHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigGroup
extends ConfigEntry {
    public final LinkedHashMap<String, ConfigEntry> entryMap = new LinkedHashMap();
    private String displayName;

    public ConfigGroup(String s) {
        super(s);
    }

    @Override
    public ConfigEntryType getConfigType() {
        return ConfigEntryType.GROUP;
    }

    public final List<ConfigEntry> sortedEntries() {
        ArrayList<ConfigEntry> list = new ArrayList<ConfigEntry>();
        list.addAll(this.entryMap.values());
        Collections.sort(list, null);
        return list;
    }

    public ConfigFile getConfigFile() {
        return this.parentGroup != null ? this.parentGroup.getConfigFile() : null;
    }

    public ConfigGroup add(ConfigEntry e, boolean copy) {
        if (e != null) {
            if (copy) {
                ConfigEntry e1 = e.copy();
                this.entryMap.put(e1.getID(), e1);
                e1.parentGroup = this;
            } else {
                this.entryMap.put(e.getID(), e);
                e.parentGroup = this;
            }
        }
        return this;
    }

    public ConfigGroup addAll(Class<?> c, Object parent, boolean copy) {
        try {
            Field[] f = c.getDeclaredFields();
            if (f != null && f.length > 0) {
                for (Field aF : f) {
                    try {
                        ConfigEntry entry;
                        aF.setAccessible(true);
                        if (!ConfigEntry.class.isAssignableFrom(aF.getType()) || (entry = (ConfigEntry)aF.get(parent)) == null || entry == this || entry instanceof ConfigFile) continue;
                        AnnotationHelper.inject(aF, parent, entry);
                        this.add(entry, copy);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public ConfigEntry copy() {
        ConfigGroup g = new ConfigGroup(this.getID());
        for (ConfigEntry e : this.entryMap.values()) {
            g.add(e, true);
        }
        return g;
    }

    @Override
    public final void func_152753_a(JsonElement o0) {
        if (o0 == null || !o0.isJsonObject()) {
            return;
        }
        this.entryMap.clear();
        JsonObject o = o0.getAsJsonObject();
        for (Map.Entry e : o.entrySet()) {
            ConfigEntryCustom entry = new ConfigEntryCustom((String)e.getKey());
            if (!((JsonElement)e.getValue()).isJsonNull()) {
                ((ConfigEntry)entry).func_152753_a((JsonElement)e.getValue());
            }
            this.add(entry, false);
        }
    }

    @Override
    public final JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        for (ConfigEntry e : this.entryMap.values()) {
            if (e.getFlag((byte)4)) continue;
            o.add(e.getID(), e.func_151003_a());
        }
        return o;
    }

    @Override
    public String getAsString() {
        return this.func_151003_a().toString();
    }

    @Override
    public List<String> getAsStringList() {
        ArrayList<String> list = new ArrayList<String>(this.entryMap.size());
        for (ConfigEntry e : this.entryMap.values()) {
            list.add(e.getAsString());
        }
        return list;
    }

    @Override
    public boolean getAsBoolean() {
        return !this.entryMap.isEmpty();
    }

    @Override
    public int getAsInt() {
        return this.entryMap.size();
    }

    public final void setDisplayName(String s) {
        this.displayName = s == null || s.isEmpty() ? null : s;
    }

    public final String getDisplayName() {
        return this.displayName == null ? LMStringUtils.firstUppercase(this.getID()) : this.displayName;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, boolean extended) {
        super.writeToNBT(tag, extended);
        if (extended && this.displayName != null) {
            tag.func_74778_a("N", this.displayName);
        }
        if (!this.entryMap.isEmpty()) {
            NBTTagCompound tag1 = new NBTTagCompound();
            for (ConfigEntry e : this.entryMap.values()) {
                NBTTagCompound tag2 = new NBTTagCompound();
                e.writeToNBT(tag2, extended);
                tag2.func_74774_a("T", e.getConfigType().ID);
                tag1.func_74782_a(e.getID(), (NBTBase)tag2);
            }
            tag.func_74782_a("V", (NBTBase)tag1);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, boolean extended) {
        super.readFromNBT(tag, extended);
        if (extended) {
            this.displayName = tag.func_74764_b("N") ? tag.func_74779_i("N") : null;
        }
        this.entryMap.clear();
        if (tag.func_74764_b("V")) {
            for (Map.Entry<String, NBTBase> entry : LMNBTUtils.entrySet((NBTTagCompound)tag.func_74781_a("V"))) {
                NBTTagCompound tag2 = (NBTTagCompound)entry.getValue();
                ConfigEntryType t = ConfigEntryType.getFromID(tag2.func_74771_c("T"));
                if (t == null) continue;
                ConfigEntry e = t.createNew(entry.getKey());
                e.readFromNBT(tag2, extended);
                this.entryMap.put(e.getID(), e);
            }
        }
    }

    public int loadFromGroup(ConfigGroup l, boolean isNBT) {
        if (l == null || l.entryMap.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (ConfigEntry e1 : l.entryMap.values()) {
            ConfigEntry e0 = this.entryMap.get(e1.getID());
            if (e0 == null) continue;
            if (e0.getAsGroup() != null) {
                ConfigGroup g1 = new ConfigGroup(e1.getID());
                if (isNBT) {
                    NBTTagCompound tag = new NBTTagCompound();
                    e1.writeToNBT(tag, false);
                    g1.readFromNBT(tag, false);
                } else {
                    g1.func_152753_a(e1.func_151003_a());
                }
                result += e0.getAsGroup().loadFromGroup(g1, isNBT);
                continue;
            }
            try {
                if (isNBT) {
                    NBTTagCompound tag = new NBTTagCompound();
                    e1.writeToNBT(tag, false);
                    e0.readFromNBT(tag, false);
                } else {
                    e0.func_152753_a(e1.func_151003_a());
                }
                ++result;
            }
            catch (Exception ex) {
                System.err.println("Can't set value " + e1.getAsString() + " for '" + e0.parentGroup.getID() + "." + e0.getID() + "' (type:" + (Object)((Object)e0.getConfigType()) + ")");
                System.err.println(ex.toString());
            }
        }
        if (result > 0) {
            this.onLoadedFromGroup(l);
        }
        return result;
    }

    protected void onLoadedFromGroup(ConfigGroup l) {
    }

    public boolean hasKey(Object key) {
        return this.entryMap.containsKey(LMUtils.getID(key));
    }

    public ConfigEntry getEntry(Object key) {
        return this.entryMap.get(LMUtils.getID(key));
    }

    public ConfigGroup getGroup(Object key) {
        ConfigEntry e = this.getEntry(key);
        return e == null ? null : e.getAsGroup();
    }

    public List<ConfigGroup> getGroups() {
        ArrayList<ConfigGroup> list = new ArrayList<ConfigGroup>();
        for (ConfigEntry e : this.entryMap.values()) {
            ConfigGroup g = e.getAsGroup();
            if (g == null) continue;
            list.add(g);
        }
        return list;
    }

    @Override
    public ConfigGroup getAsGroup() {
        return this;
    }

    public int getTotalEntryCount() {
        int count = 0;
        for (ConfigEntry e : this.entryMap.values()) {
            if (e.getAsGroup() == null) {
                ++count;
                continue;
            }
            count += e.getAsGroup().getTotalEntryCount();
        }
        return count;
    }

    public int getDepth() {
        return this.parentGroup == null ? 0 : this.parentGroup.getDepth() + 1;
    }

    public ConfigGroup generateSynced(boolean copy) {
        ConfigGroup out = new ConfigGroup(this.getID());
        for (ConfigEntry e : this.entryMap.values()) {
            if (e.getFlag((byte)0)) {
                out.add(e, copy);
                continue;
            }
            if (e.getAsGroup() == null) continue;
            ConfigGroup g = e.getAsGroup().generateSynced(copy);
            if (g.entryMap.isEmpty()) continue;
            out.add(g, false);
        }
        return out;
    }
}

